/*!
        @file    fieldIO_Fortran.h

        @brief

        @author  Hideo Matsufuru (matsufuru)
                 $LastChangedBy: aoyama $

        @date    $LastChangedDate: 2014-04-12 16:31:14 #$

        @version $LastChangedRevision: 2314 $
*/

#ifndef FIELDIO_FORTRAN_INCLUDED
#define FIELDIO_FORTRAN_INCLUDED

#include <string>
using std::string;

#include "fieldIO.h"

#include "Field/index_lex.h"
#include "Field/field.h"

//! FieldIO_Fortran class for file I/O of Field data in Fortran binary format.

/*!
   This class reads configuration from binary data file
   generated by Fortran code.
   Before opening file, endian of the file must be specified
   using set_fileEndian() function.
   Only input from file is available.
                                        [28 Dec 2011 H.Matsufuru]

   In this class, we assumed the data alignment as followes,\n
   \verbatim double U[NDIMENSION][NT][NZ][NY][NX][NCOLOR][NCOLOR][2] \endverbatim
   (i.e. the rightmost index runs fastest)   [11 June 2012 S.UEDA]

   FieldIO_Fortran class provides file I/O of Field data in Fortran binary
   format. Fortran binary data record has heading and trailing bytes
   that represents length of the record.
   The size of heading and trailer is 4 (32bit) in this implementation.

   File I/O is performed on the primary node (rank 0 usually), and
   the field data is gathered from/scattered to parallel nodes.

   Data layout is specified by format specified at constructor.
   The above corresponds to JLQCD layout.
 */


class FieldIO_Fortran : public FieldIO
{
 public:
  static const std::string class_name;

 public:
  FieldIO_Fortran(const IO_Format::Format *format) : FieldIO(format)
  {}

  void read_file(Field& v, const std::string& filename);
  void write_file(Field& v, const std::string& filename);
};
#endif
