#!/bin/sh
#
MPI_FLAG=`sed -n '/use_mpi = /p' Makefile.in`
OPT_FLAG=`sed -n '/use_optimize = /p' Makefile.in`
LIME_FLAG=`sed -n '/use_lime_library = /p' Makefile.in`
DBG_FLAG=`sed -n '/use_debug = /p' Makefile.in`
TEST_FLAG=`sed -n '/use_test = /p' Makefile.in`
#
PC_GCC=`sed -n '/target = PC_GCC/p' Makefile.in`
PC_INTEL=`sed -n '/target = PC_INTEL/p' Makefile.in`
KEKSR=`sed -n '/target = KEKSR/p' Makefile.in`
KEKBGQ=`sed -n '/target = KEKBGQ/p' Makefile.in`
YITPSR=`sed -n '/target = YITPSR/p' Makefile.in`
FX10=`sed -n '/target = FX10/p' Makefile.in`
#
echo ""
echo "################################################################################"
echo "######################## bridge++ Makefile Setup script ########################"
echo "################################################################################"
#
echo ""
MAKE_FILE_BK=`date +%Y%m%d%H%M`
echo "Current Makefile is saved to Makefile.$MAKE_FILE_BK."
cp Makefile Makefile.$MAKE_FILE_BK
echo ""
#
echo "### Select Communicator Type ###"
echo "1 [Single]"
echo "2 [MPI]"
echo ""
echo Communication Type:?
  read COMM
  case ${COMM} in
   1)
    echo ""
    echo "You have selected [Single]"
    cp -p Makefile.in Makefile.tmp
    ;;
   2)
    echo ""
    echo "You have selected [MPI]"
    sed -e "s/$MPI_FLAG/use_mpi = yes/" Makefile.in > Makefile.tmp
    ;;
   *)
    echo "Error: invalid number \""${COMM}"\"."
    exit 1
    ;;
  esac
#
echo ""
echo "### Select Compiler ###"
echo "1 [PC WorkStation With GNU C++](default)"
echo "2 [PC WorkStation With Intel C++]"
echo "3 [SR16000@KEK]"
echo "4 [SR16000@YITP]"
echo "5 [BuleGene/Q@KEK]"
echo "6 [FX10@TOKYO]"
echo "7 [Others]"
echo ""
echo Compiler Number:?
  read COMP
  case ${COMP} in
   1)
    echo ""
    echo "You have selected [PC WorkStation With GNU C++](default)"
    sed -e 's/#target = PC_GCC/target = PC_GCC/' Makefile.tmp > Makefile
    ;;
   2)
    echo ""
    echo "You have selected PC WorkStation With Intel C++]"
    sed -e 's/#target = PC_INTEL/target = PC_INTEL/' Makefile.tmp > Makefile
    ;;
   3)
    echo ""
    echo "You have selected [SR16000@KEK]"
    sed -e 's/#target = KEKSR/target = KEKSR/' Makefile.tmp > Makefile
    ;;
   4)
    echo ""
    echo "You have selected [SR16000@YITP]"
    sed -e 's/#target = YITPSR/target = YITPSR/' Makefile.tmp > Makefile
    ;;
   5)
    echo ""
    echo "You have selected [BuleGene/Q@KEK]"
    sed -e 's/#target = KEKBGQ/target = KEKBGQ/' Makefile.tmp > Makefile
    ;;
   6)
    echo ""
    echo "You have selected [FX10@TOKYO]"
    sed -e 's/#target = FX10/target = FX10/' Makefile.tmp > Makefile
    ;;
   7)
    echo ""
    echo "You have selected [Others]"
    echo "should be modified Makefile by yourself![Others]"
    sed -e 's/#target = PC_GCC/target = PC_GCC/' Makefile.tmp > Makefile
    ;;
   *)
    echo ""
    echo "Error: invalid number \""${COMP}"\"."
    exit 1
    ;;
  esac
echo ""
#
rm -rf Makefile.tmp
#
echo "Makefile is created."
