/*!
        @file    $Id:: action.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef ACTION_INCLUDED
#define ACTION_INCLUDED

#include <string>
#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field.h"
#include "fopr.h"
#include "force.h"
#include "randomNumbers.h"
#include "bridgeIO.h"

//! Base class of HMC action class family.

/*!
   This class defines interface of Action-type classes.
                                   [28 Dec 2011 H.Matsufuru]
 */

class Action
{
 public:

  Action()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Action() {}

  virtual void set_parameters(const Parameters& param) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  //! setting pointer to the gauge configuration.
  virtual void set_config(Field *U) = 0;

  //! Langevis step.
  virtual double langevin(RandomNumbers *) = 0;

  //! calculate Hamiltonian of this action term.
  virtual double calcH() = 0;

  //! returns force for molcular dynamical update of conjugate momenta.
  virtual const Field force() = 0;

  //! to be called when gauge configuration is updated.
  virtual void notify_linkv() = 0;

 protected:
  Bridge::VerboseLevel m_vl;
};
#endif
