/*!
        @file    $Id:: action_F_Ratio.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_F_RATIO_INCLUDED
#define ACTION_F_RATIO_INCLUDED

#include "action.h"
#include "solver.h"

#include "bridgeIO.h"
using Bridge::vout;

//! HMC action for Hasenbusch preconditioned fermions.

/*!
    This class is used to define an fermion action used in HMC
    which is given as a ratio of two fermion operators.
    Two sets of fermion and Force operators and given at the
    construction.
                                       [05 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    Selectors are implemented.         [02 Feb 2013 Y.Namekawa]
    (Selectors are replaced with factories by Aoyama-san)
 */

class Action_F_Ratio : public Action
{
 private:
  Field *m_U;
  int   m_status_linkv;

  Fopr        *m_fopr_prec;       // preconditioner
  Force       *m_fopr_prec_force; // force of preconditioner
  Fopr        *m_fopr;            // dynamical fermion
  Force       *m_fopr_force;      // force of dynamical fermion
  Field       m_psf;              // pseudofermion field
  std::string m_label;            // label of action
  Field       m_force;

  Solver *m_solver_H_prec;
  Solver *m_solver_MD;
  Solver *m_solver_H;

  RandomNumbers *m_rand;

 public:

  Action_F_Ratio(
    Fopr *fopr_prec, Force *fopr_prec_force,
    Fopr *fopr, Force *fopr_force)
    : Action(),
      m_fopr_prec(fopr_prec), m_fopr_prec_force(fopr_prec_force),
      m_fopr(fopr), m_fopr_force(fopr_force)
  {
    set_parameters();
  }

  ~Action_F_Ratio()
  {
    delete m_solver_H_prec;
    delete m_solver_MD;
    delete m_solver_H;
  }

  void set_parameters(const Parameters&);
  void set_parameters();

  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  std::string get_label()
  {
    return m_label;
  }

  void set_config(Field *U)
  {
    m_U = U;

    m_fopr_prec->set_config(U);
    m_fopr_prec_force->set_config(U);

    m_fopr->set_config(U);
    m_fopr_force->set_config(U);
  }

  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  double langevin(RandomNumbers *);

  double calcH();

  const Field force();
};
#endif
