/*!
        @file    $Id:: action_F_Ratio_eo.h #$

        @brief

        @author  <Yusuke Namekawa> namekawa@ccs.tsukuba.ac.jp(namekawa)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_F_RATIO_EO_INCLUDED
#define ACTION_F_RATIO_EO_INCLUDED

#include "action.h"
#include "fprop.h"

#include "bridgeIO.h"
using Bridge::vout;

//! HMC action for Hasenbusch preconditioned fermions.

/*!
    This class is used to define an fermion action used in HMC
    which is given as a ratio of two fermion operators.
    Two sets of fermion and Force operators and given at the
    construction.
                                        [05 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    Even-odd is implemented.            [03 Mar 2013 Y.Namekawa]
 */

class Action_F_Ratio_eo : public Action
{
 private:
  Field *m_U;
  int   m_status_linkv;

  Fopr        *m_fopr_prec;       // preconditioner
  Force       *m_fopr_prec_force; // force of preconditioner
  Fopr        *m_fopr;            // dynamical fermion
  Force       *m_fopr_force;      // force of dynamical fermion
  Field       m_psf;              // pseudofermion field
  std::string m_label;            // label of action
  Field       m_force;

  Fprop *m_fprop_H_prec;
  Fprop *m_fprop_MD;
  Fprop *m_fprop_H;

  RandomNumbers *m_rand;


 public:

  Action_F_Ratio_eo(
    Fopr *fopr_prec, Force *fopr_prec_force,
    Fopr *fopr, Force *fopr_force,
    Fprop *fprop_H_prec,
    Fprop *fprop_MD, Fprop *fprop_H)
    : Action(),
      m_fopr_prec(fopr_prec), m_fopr_prec_force(fopr_prec_force),
      m_fopr(fopr), m_fopr_force(fopr_force),
      m_fprop_H_prec(fprop_H_prec),
      m_fprop_MD(fprop_MD), m_fprop_H(fprop_H)
  {
    set_parameters();
  }

  ~Action_F_Ratio_eo() {}

  void set_parameters(const Parameters&);
  void set_parameters();

  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  std::string get_label()
  {
    return m_label;
  }

  void set_config(Field *U);

  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  double langevin(RandomNumbers *);
  double calcH();
  const Field force();
};
#endif
