/*!
        @file    $Id:: action_F_Rational_Frame_SF.cpp #$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "action_F_Rational_Frame_SF.h"

#ifdef USE_PARAMETERS_FACTORY
#include "parameters_factory.h"
#endif

using Bridge::vout;

//- parameter entries
namespace {
  void append_entry(Parameters& param)
  {
    param.Register_string("verbose_level", "NULL");
  }


#ifdef USE_PARAMETERS_FACTORY
  bool init_param = ParametersFactory::Register("Action.F_Rational_Frame_SF", append_entry);
#endif
}
//- end

//- parameters class
Parameters_Action_F_Rational_frame_SF::Parameters_Action_F_Rational_frame_SF() { append_entry(*this); }
//- end

//====================================================================
void Action_F_Rational_frame_SF::set_parameters(const Parameters& params)
{
  const string str_vlevel = params.get_string("verbose_level");

  m_vl = vout.set_verbose_level(str_vlevel);
}


//====================================================================
void Action_F_Rational_frame_SF::setup()
{
  int Nc   = CommonParameters::Nc();
  int Nvol = CommonParameters::Nvol();
  int Ndim = CommonParameters::Ndim();
  int NinG = 2 * Nc * Nc;

  m_force.reset(NinG, Nvol, Ndim);

  // link variable update flag
  m_status_linkv = 0;
}


//====================================================================
double Action_F_Rational_frame_SF::langevin(RandomNumbers *rand)
{
  int NinF     = m_fopr_langev->field_nin();
  int NvolF    = m_fopr_langev->field_nvol();
  int NexF     = m_fopr_langev->field_nex();
  int size_psf = NinF * NvolF * NexF * CommonParameters::NPE();

  m_psf.reset(NinF, NvolF, NexF);

  vout.general(m_vl, "  Action_F_Rational_frame_SF: %s\n", m_label.c_str());

  Field xi(NinF, NvolF, NexF);
  rand->gauss_lex_global(xi);

  m_fopr_langev->set_config(m_U);
  m_psf = m_fopr_langev->mult(xi);

  Field_F_SF setzero;
  setzero.set_boundary_zero(xi);

  double xi2   = xi.norm();
  double H_psf = xi2 * xi2;

  vout.general(m_vl, "    H_Frational  = %18.8f\n", H_psf);
  vout.general(m_vl, "    H_F/dof      = %18.8f\n", H_psf / size_psf);

  return H_psf;
}


//====================================================================
double Action_F_Rational_frame_SF::calcH()
{
  int NinF     = m_fopr_H->field_nin();
  int NvolF    = m_fopr_H->field_nvol();
  int NexF     = m_fopr_H->field_nex();
  int size_psf = NinF * NvolF * NexF * CommonParameters::NPE();

  Field v1(NinF, NvolF, NexF);

  vout.general(m_vl, "  Action_F_Rational: %s\n", m_label.c_str());

  m_fopr_H->set_config(m_U);
  v1 = m_fopr_H->mult(m_psf);

  double H_psf = v1 * m_psf;

  vout.general(m_vl, "    H_Frational  = %18.8f\n", H_psf);
  vout.general(m_vl, "    H_F/dof      = %18.8f\n", H_psf / size_psf);

  return H_psf;
}


//====================================================================
const Field Action_F_Rational_frame_SF::force()
{
  if (m_status_linkv == 0) {
    int Nvol = m_U->nvol();
    int Nex  = m_U->nex();

    Field_G force(Nvol, Nex), force1(Nvol, Nex);

    vout.general(m_vl, "  Action_F_Rational: %s\n", m_label.c_str());

    m_fopr_force_MD->set_config(m_U);
    force = m_fopr_force_MD->force_core(m_psf);

    Field_G_SF Fboundary(force);
    Fboundary.set_boundary_spatial_link_zero();
    m_force = (Field)Fboundary;

    //   m_force = (Field)force;
    ++m_status_linkv;

    double Fave, Fmax, Fdev;
    m_force.stat(Fave, Fmax, Fdev);
    vout.general(m_vl, "    Frational_frame_ave = %12.6f  Frational_frame_max = %12.6f  Frational_frame_dev = %12.6f\n",
                 Fave, Fmax, Fdev);

    return m_force;
  } else {
    vout.general(m_vl, "  Frational returns previous force.\n");
    return m_force;
  }
}


//====================================================================
//============================================================END=====
