/*!
        @file    $Id:: action_F_Rational_Frame_SF.h #$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_FRATIONAL_FRAME_SF_INCLUDED
#define ACTION_FRATIONAL_FRAME_SF_INCLUDED

#include "action.h"
#include "fopr_Rational.h"
#include "force_F_Rational.h"

#include "field_G_SF.h"
#include "field_F_SF.h"

#include "bridgeIO.h"
using Bridge::vout;

//! action class for RHMC, with externally constructed Fopr_Rational.

/*!
    Action class alternative to Action_F_Rational.
    For the class, Fopr and Force objects are instantiated outside
    the class and specified at the construction.
    This class just provides the framework of rational actions.
                                         [28 Dec 2011 H.Matsufuru]
 */

//- parameters class
class Parameters_Action_F_Rational_frame_SF : virtual public Parameters
{
 public:
  Parameters_Action_F_Rational_frame_SF();
};
//- end

class Action_F_Rational_frame_SF : public Action {
 private:
  std::string m_label;   // label of action

  Fopr  *m_fopr_langev;
  Fopr  *m_fopr_H;
  Force *m_fopr_force_MD;

  Field *m_U;
  int   m_status_linkv;

  Field m_psf;
  Field m_force;


 public:
  //! constructor requires pointers to Fopr and Force instances.
  Action_F_Rational_frame_SF(Fopr *fopr_langev, Fopr *fopr_H,
                             Force *fopr_force_MD)
  {
    m_fopr_langev   = fopr_langev;
    m_fopr_H        = fopr_H;
    m_fopr_force_MD = fopr_force_MD;
    setup();
  }

  //! destructor. constructed instances are deconstructed in tydyup().
  ~Action_F_Rational_frame_SF()
  {
  }

  //! setting parameters and creating class instances.
  void set_parameters(const Parameters& params);

  //! set the label of action.
  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  //! returns the label of action.
  std::string get_label()
  {
    return m_label;
  }

  //! setting gauge configuration.
  void set_config(Field *U)
  {
    m_U = U;
    m_fopr_langev->set_config(U);
    m_fopr_H->set_config(U);
    m_fopr_force_MD->set_config(U);
  }

  //! to be called when link variable is updated.
  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  //! Langevin step called at the beginning of HMC.
  double langevin(RandomNumbers *);

  //! calculation of Hamiltonian.
  double calcH();

  //! returns the force for updating conjugate momentum.
  const Field force();

 private:

  //! creating instances. called from set_parameters().
  void setup();

  //! destruct class instances constructed in setup()
  void tidyup();
};
#endif
