/*!
        @file    $Id:: action_F_Standard.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_F_STANDARD_INCLUDED
#define ACTION_F_STANDARD_INCLUDED

#include <valarray>
#include "action.h"
#include "solver.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Standard fermion action for HMC.

/*!
    This class is used to define an action used in HMC.
    Fermion and Force operators and given at the construction.
                                       [05 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    selector of solver is implemented. [02 Feb 2013 Y.Namekawa]
    (Selectors are replaced with factories by Aoyama-san)
 */

class Action_F_Standard : public Action
{
 private:
  Fopr        *m_fopr;
  Force       *m_fopr_force;
  Field       m_psf;
  std::string m_label;
  Field       m_force;

  Solver *m_solver;

  Field *m_U;
  int   m_status_linkv;

  RandomNumbers *m_rand;

 public:

  Action_F_Standard(Fopr *fopr, Force *fopr_force)
    : Action(), m_fopr(fopr), m_fopr_force(fopr_force)
  {
    set_parameters();
  }

  ~Action_F_Standard()
  {
    delete m_solver;
  }

  void set_parameters(const Parameters&);
  void set_parameters();

  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  std::string get_label()
  {
    return m_label;
  }

  void set_config(Field *U)
  {
    m_U = U;
    m_fopr->set_config(U);
    m_fopr_force->set_config(U);
  }

  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  double langevin(RandomNumbers *);

  double calcH();

  const Field force();
};
#endif
