/*!
        @file    $Id:: action_F_Standard_lex.h #$

        @brief

        @author  <UEDA, Satoru> sueda@post.kek.jp (sueda)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_F_STANDARD_LEX_INCLUDED
#define ACTION_F_STANDARD_LEX_INCLUDED

#include "action.h"
#include "fprop.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Standard fermion action for HMC.

/*!
    This class is used to define an action used in HMC.
    Fermion and Force operators and given at the construction.
                                        [05 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    Fprop is introduced.                [03 Mar 2013 Y.Namekawa]
 */

class Action_F_Standard_lex : public Action
{
 private:
  Fopr        *m_fopr;
  Force       *m_fopr_force;
  Field       m_psf;
  std::string m_label;
  Field       m_force;

  Fprop *m_fprop_MD;
  Fprop *m_fprop_H;

  Field *m_U;
  int   m_status_linkv;


 public:

  Action_F_Standard_lex(
    Fopr *fopr, Force *fopr_force, Fprop *fprop_MD, Fprop *fprop_H)
    : Action(),
      m_fopr(fopr), m_fopr_force(fopr_force), m_fprop_MD(fprop_MD), m_fprop_H(fprop_H)
  {
    set_parameters();
  }

  ~Action_F_Standard_lex()
  {
    // delete m_fprop;
  }

  void set_parameters(const Parameters&);
  void set_parameters();

  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  std::string get_label()
  {
    return m_label;
  }

  void set_config(Field *U);

  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  double langevin(RandomNumbers *);

  double calcH();

  const Field force();
};
#endif
