/*!
        @file    $Id:: action_G_Plaq.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_G_PLAQ_INCLUDED
#define ACTION_G_PLAQ_INCLUDED

#include "action.h"
#include "staples.h"

#include "bridgeIO.h"
using Bridge::vout;

//! HMC action class for plaquette gauge action.

/*!
    Standard plaquette gauge action.
                             [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.     [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Action_G_Plaq : virtual public Parameters
{
 public:
  Parameters_Action_G_Plaq();
};
//- end

class Action_G_Plaq : public Action
{
 private:
  double      m_beta;
  std::string m_label;
  Field       m_force;

  Field_G *m_U;
  int     m_status_linkv;
  Staples m_staple;

  RandomNumbers *m_rand;

 public:

  Action_G_Plaq()
    : Action() {}

  ~Action_G_Plaq() {}

  void set_parameters(const Parameters& params);
  void set_parameters(double beta);

  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  std::string get_label()
  {
    return m_label;
  }

  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
  }

  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  double langevin(RandomNumbers *);

  double calcH();

  const Field force();
};
#endif
