/*!
        @file    $Id:: action_G_Rectangle.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef ACTION_G_RECTANGLE_INCLUDED
#define ACTION_G_RECTANGLE_INCLUDED

#include "action.h"
#include "staples.h"
#include "shiftField_lex.h"

#include "bridgeIO.h"
using Bridge::vout;

//! HMC action class for rectangular gauge action.

/*!
    Gauge action with plaquette and rectangular Wilson loops.
    Iwasaki, Luscher-Weisz, DBW2 are examples of this type
    of action.
                                   [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Action_G_Rectangle : virtual public Parameters
{
 public:
  Parameters_Action_G_Rectangle();
};
//- end

class Action_G_Rectangle : public Action
{
 private:
  double      m_beta;
  double      m_c_plaq;
  double      m_c_rect;
  std::string m_label;
  Field       m_force;

  Field_G        *m_U;
  int            m_status_linkv;
  Staples        m_staple;
  ShiftField_lex m_shift;

  RandomNumbers *m_rand;

 public:
  Action_G_Rectangle()
    : Action() {}

  ~Action_G_Rectangle() {}

  void set_parameters(const Parameters& params);
  void set_parameters(double beta, double c_plaq, double c_rect);

  void set_label(std::string label)
  {
    m_label = label;
    vout.detailed(m_vl, "  label: %s\n", m_label.c_str());
  }

  std::string get_label()
  {
    return m_label;
  }

  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
  }

  void notify_linkv()
  {
    m_status_linkv = 0;
  }

  double langevin(RandomNumbers *);

  double calcH();

  const Field force();
};
#endif
