/*!
        @file    $Id:: eigensolver.h #$

        @brief

        @author  $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-22 16:55:30 #$

        @version $LastChangedRevision: 943 $
*/

#ifndef EIGENSOLVER_INCLUDED
#define EIGENSOLVER_INCLUDED

#include <valarray>
#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field.h"

//! Eigensolver class for abstract base class of eigen solvers.

/**
   Eigensolver class provides an abstract base class for solvers
   of eigenvalues and eigenvectors.
 */

class Eigensolver
{
 public:

  Eigensolver()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Eigensolver() {}

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void solve(std::valarray<double>& TDa,
                     std::valarray<Field>& vk,
                     int& Nsbt, int& Nconv,
                     const Field& b) = 0;

 protected:
  Bridge::VerboseLevel m_vl;
};
#endif
