/*!
        @file    $Id:: eigensolver_IRLanczos.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: aoym $

        @date    $LastChangedDate:: 2013-03-21 15:28:34 #$

        @version $LastChangedRevision: 854 $
*/

#ifndef EIGENSOLVER_IRLANCZOS_INCLUDED
#define EIGENSOLVER_IRLANCZOS_INCLUDED

#include "eigensolver.h"
#include "fopr.h"
#include "sortField.h"
#include "bridge_complex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Eigensolver_IRLanczos : virtual public Parameters
{
 public:
  Parameters_Eigensolver_IRLanczos();
};
//- end

//! Eigenvalue solver with Implicitly Restarted Lanczos algorithm.

/*!
    This class determines eigenvalues and eigenvectors for a given
    fermion operator.
    Low- or high-lying eigenmodes are determined by chaning
    SortField class object.
                                 [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.         [14 Nov 2012 Y.Namekawa]
 */

class Eigensolver_IRLanczos : public Eigensolver
{
 private:

  int    m_Nk;
  int    m_Np;
  int    m_Niter_eigen;
  double m_Enorm_eigen;
  double m_Vthreshold;

  Fopr      *m_fopr;
  SortField *m_sort;

 public:

  Eigensolver_IRLanczos(Fopr *fopr, SortField *sort)
    : Eigensolver(), m_fopr(fopr), m_sort(sort) {}

  void set_parameters(const Parameters& params);
  void set_parameters(int Nk, int Np, int Niter_eigen, double Enorm_eigen,
                      double Vthreshold);

  void solve(std::valarray<double>& TDa, std::valarray<Field>& vk,
             int& Nsbt, int& Nconv, const Field& b);

 private:

  void step(int Nm, int k,
            std::valarray<double>& TDa,
            std::valarray<double>& TDb,
            std::valarray<Field>& vk, Field& f);

  void qrtrf(std::valarray<double>& TDa, std::valarray<double>& TDb,
             int Nk, int Nm, std::valarray<double>& Qt,
             double Dsh, int kmin, int kmax);

  void tqri(std::valarray<double>& TDa, std::valarray<double>& TDb,
            int Nk, int Nm, std::valarray<double>& Qt);

  void setUnit_Qt(int Nm, std::valarray<double>& Qt);

  void schmidt_orthogonalization(Field& w, std::valarray<Field>& vk, int k);
};
#endif
