/*!
        @file    $Id:: field_G_imp.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#include "field_G.h"

#include "commonParameters.h"
#include "communicator.h"
#include "bridgeIO.h"
using Bridge::vout;

#include "mat_SU_N.h"

//====================================================================
void Field_G::mult_Field_Gnn(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * 2 + ig2;
        int jg1 = ic1 * Nc2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] =
          g1[0 + jg1] * g2[0 + jg2] - g1[1 + jg1] * g2[1 + jg2]
          + g1[2 + jg1] * g2[6 + jg2] - g1[3 + jg1] * g2[7 + jg2]
          + g1[4 + jg1] * g2[12 + jg2] - g1[5 + jg1] * g2[13 + jg2];
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] =
          g1[0 + jg1] * g2[1 + jg2] + g1[1 + jg1] * g2[0 + jg2]
          + g1[2 + jg1] * g2[7 + jg2] + g1[3 + jg1] * g2[6 + jg2]
          + g1[4 + jg1] * g2[13 + jg2] + g1[5 + jg1] * g2[12 + jg2];
      }
    }
  }
}


//====================================================================
void Field_G::mult_Field_Gdn(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * 2 + ig2;
        int jg1 = ic1 * 2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] =
          g1[0 + jg1] * g2[0 + jg2] + g1[1 + jg1] * g2[1 + jg2]
          + g1[6 + jg1] * g2[6 + jg2] + g1[7 + jg1] * g2[7 + jg2]
          + g1[12 + jg1] * g2[12 + jg2] + g1[13 + jg1] * g2[13 + jg2];
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] =
          g1[0 + jg1] * g2[1 + jg2] - g1[1 + jg1] * g2[0 + jg2]
          + g1[6 + jg1] * g2[7 + jg2] - g1[7 + jg1] * g2[6 + jg2]
          + g1[12 + jg1] * g2[13 + jg2] - g1[13 + jg1] * g2[12 + jg2];
      }
    }
  }
}


//====================================================================
void Field_G::mult_Field_Gnd(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * Nc2 + ig2;
        int jg1 = ic1 * Nc2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] =
          g1[0 + jg1] * g2[0 + jg2] + g1[1 + jg1] * g2[1 + jg2]
          + g1[2 + jg1] * g2[2 + jg2] + g1[3 + jg1] * g2[3 + jg2]
          + g1[4 + jg1] * g2[4 + jg2] + g1[5 + jg1] * g2[5 + jg2];
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] =
          -g1[0 + jg1] * g2[1 + jg2] + g1[1 + jg1] * g2[0 + jg2]
          - g1[2 + jg1] * g2[3 + jg2] + g1[3 + jg1] * g2[2 + jg2]
          - g1[4 + jg1] * g2[5 + jg2] + g1[5 + jg1] * g2[4 + jg2];
      }
    }
  }
}


//====================================================================
void Field_G::mult_Field_Gdd(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * Nc2 + ig2;
        int jg1 = ic1 * 2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] =
          g1[0 + jg1] * g2[0 + jg2] - g1[1 + jg1] * g2[1 + jg2]
          + g1[6 + jg1] * g2[2 + jg2] - g1[7 + jg1] * g2[3 + jg2]
          + g1[12 + jg1] * g2[4 + jg2] - g1[13 + jg1] * g2[5 + jg2];
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] =
          -g1[0 + jg1] * g2[1 + jg2] - g1[1 + jg1] * g2[0 + jg2]
          - g1[6 + jg1] * g2[3 + jg2] - g1[7 + jg1] * g2[2 + jg2]
          - g1[12 + jg1] * g2[5 + jg2] - g1[13 + jg1] * g2[4 + jg2];
      }
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gnn(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * 2 + ig2;
        int jg1 = ic1 * Nc2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] += ff *
                                           (g1[0 + jg1] * g2[0 + jg2] - g1[1 + jg1] * g2[1 + jg2]
                                            + g1[2 + jg1] * g2[6 + jg2] - g1[3 + jg1] * g2[7 + jg2]
                                            + g1[4 + jg1] * g2[12 + jg2] - g1[5 + jg1] * g2[13 + jg2]);
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] += ff *
                                               (g1[0 + jg1] * g2[1 + jg2] + g1[1 + jg1] * g2[0 + jg2]
                                                + g1[2 + jg1] * g2[7 + jg2] + g1[3 + jg1] * g2[6 + jg2]
                                                + g1[4 + jg1] * g2[13 + jg2] + g1[5 + jg1] * g2[12 + jg2]);
      }
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gdn(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * 2 + ig2;
        int jg1 = ic1 * 2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] += ff *
                                           (g1[0 + jg1] * g2[0 + jg2] + g1[1 + jg1] * g2[1 + jg2]
                                            + g1[6 + jg1] * g2[6 + jg2] + g1[7 + jg1] * g2[7 + jg2]
                                            + g1[12 + jg1] * g2[12 + jg2] + g1[13 + jg1] * g2[13 + jg2]);
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] += ff *
                                               (g1[0 + jg1] * g2[1 + jg2] - g1[1 + jg1] * g2[0 + jg2]
                                                + g1[6 + jg1] * g2[7 + jg2] - g1[7 + jg1] * g2[6 + jg2]
                                                + g1[12 + jg1] * g2[13 + jg2] - g1[13 + jg1] * g2[12 + jg2]);
      }
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gnd(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * Nc2 + ig2;
        int jg1 = ic1 * Nc2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] += ff *
                                           (g1[0 + jg1] * g2[0 + jg2] + g1[1 + jg1] * g2[1 + jg2]
                                            + g1[2 + jg1] * g2[2 + jg2] + g1[3 + jg1] * g2[3 + jg2]
                                            + g1[4 + jg1] * g2[4 + jg2] + g1[5 + jg1] * g2[5 + jg2]);
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] += ff *
                                               (-g1[0 + jg1] * g2[1 + jg2] + g1[1 + jg1] * g2[0 + jg2]
                                                - g1[2 + jg1] * g2[3 + jg2] + g1[3 + jg1] * g2[2 + jg2]
                                                - g1[4 + jg1] * g2[5 + jg2] + g1[5 + jg1] * g2[4 + jg2]);
      }
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gdd(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  double *g1;
  double *g2;
  g1 = const_cast<Field_G *>(&u1)->ptr(0);
  g2 = const_cast<Field_G *>(&u2)->ptr(0);
  int Nc2 = 2 * m_Nc;
  int Ndf = Nc2 * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig1 = Ndf * (site + m_Nvol * ex1);
    int ig2 = Ndf * (site + m_Nvol * ex2);
    int ig  = Ndf * (site + m_Nvol * ex);
    for (int ic2 = 0; ic2 < m_Nc; ++ic2) {
      for (int ic1 = 0; ic1 < m_Nc; ++ic1) {
        int jg2 = ic2 * Nc2 + ig2;
        int jg1 = ic1 * 2 + ig1;
        field[2 * ic2 + Nc2 * ic1 + ig] += ff *
                                           (g1[0 + jg1] * g2[0 + jg2] - g1[1 + jg1] * g2[1 + jg2]
                                            + g1[6 + jg1] * g2[2 + jg2] - g1[7 + jg1] * g2[3 + jg2]
                                            + g1[12 + jg1] * g2[4 + jg2] - g1[13 + jg1] * g2[5 + jg2]);
        field[2 * ic2 + 1 + Nc2 * ic1 + ig] += ff *
                                               (-g1[0 + jg1] * g2[1 + jg2] - g1[1 + jg1] * g2[0 + jg2]
                                                - g1[6 + jg1] * g2[3 + jg2] - g1[7 + jg1] * g2[2 + jg2]
                                                - g1[12 + jg1] * g2[5 + jg2] - g1[13 + jg1] * g2[4 + jg2]);
      }
    }
  }
}


//====================================================================
void Field_G::at_Field_G(int ex)
{
  assert(ex < m_Nex);

  int Ndf = 2 * m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig = Ndf * (site + m_Nvol * ex);

    for (int a = 0; a < m_Nc; ++a) {
      for (int b = a + 1; b < m_Nc; ++b) {
        double re = field[2 * (m_Nc * a + b) + ig]
                    - field[2 * (m_Nc * b + a) + ig];
        double im = field[2 * (m_Nc * a + b) + 1 + ig]
                    + field[2 * (m_Nc * b + a) + 1 + ig];

        field[2 * (m_Nc * a + b) + ig]     = 0.5 * re;
        field[2 * (m_Nc * a + b) + 1 + ig] = 0.5 * im;

        field[2 * (m_Nc * b + a) + ig]     = -0.5 * re;
        field[2 * (m_Nc * b + a) + 1 + ig] = 0.5 * im;
      }
    }
    double tr = 0.0;
    for (int cc = 0; cc < m_Nc; ++cc) {
      tr += field[2 * (m_Nc * cc + cc) + 1 + ig];
    }
    tr = tr / m_Nc;
    for (int cc = 0; cc < m_Nc; ++cc) {
      field[2 * (m_Nc * cc + cc) + ig]      = 0.0;
      field[2 * (m_Nc * cc + cc) + 1 + ig] -= tr;
    }
  }
}


//====================================================================
void Field_G::ah_Field_G(int ex)
{
  assert(ex < m_Nex);

  int Ndf = 2 * m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    int ig = Ndf * (site + m_Nvol * ex);

    for (int a = 0; a < m_Nc; ++a) {
      for (int b = a; b < m_Nc; ++b) {
        double re = field[2 * (m_Nc * a + b) + ig]
                    - field[2 * (m_Nc * b + a) + ig];
        double im = field[2 * (m_Nc * a + b) + 1 + ig]
                    + field[2 * (m_Nc * b + a) + 1 + ig];

        field[2 * (m_Nc * a + b) + ig]     = 0.5 * re;
        field[2 * (m_Nc * a + b) + 1 + ig] = 0.5 * im;

        field[2 * (m_Nc * b + a) + ig]     = -0.5 * re;
        field[2 * (m_Nc * b + a) + 1 + ig] = 0.5 * im;
      }
    }
  }
}


//====================================================================
//============================================================END=====
