/*!
        @file    $Id:: field_G.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#include "field_G.h"

#include "commonParameters.h"
#include "communicator.h"
#include "bridgeIO.h"
using Bridge::vout;

#include "mat_SU_N.h"


//====================================================================
void Field_G::mult_Field_Gnn(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat(site, ex1) * u2.mat(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     = ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] = ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::mult_Field_Gdn(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat_dag(site, ex1) * u2.mat(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     = ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] = ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::mult_Field_Gnd(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat(site, ex1) * u2.mat_dag(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     = ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] = ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::mult_Field_Gdd(int ex, const Field_G& u1, int ex1,
                             const Field_G& u2, int ex2)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat_dag(site, ex1) * u2.mat_dag(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     = ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] = ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gnn(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat(site, ex1) * u2.mat(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     += ff * ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] += ff * ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gdn(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat_dag(site, ex1) * u2.mat(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     += ff * ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] += ff * ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gnd(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat(site, ex1) * u2.mat_dag(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     += ff * ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] += ff * ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::multadd_Field_Gdd(int ex, const Field_G& u1, int ex1,
                                const Field_G& u2, int ex2, double ff)
{
  assert(ex < m_Nex);
  assert(ex1 < u1.nex());
  assert(ex2 < u2.nex());
  assert(u1.nvol() == m_Nvol);
  assert(u2.nvol() == m_Nvol);

  Mat_SU_N ut(m_Nc);
  int      Ncp = m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    ut = u1.mat_dag(site, ex1) * u2.mat_dag(site, ex2);
    for (int cc = 0; cc < Ncp; ++cc) {
      field[myindex(2 * cc, site, ex)]     += ff * ut.r(cc);
      field[myindex(2 * cc + 1, site, ex)] += ff * ut.i(cc);
    }
  }
}


//====================================================================
void Field_G::at_Field_G(int ex)
{
  assert(ex < m_Nex);

  //  int Ndf  = 2 * m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    //    int ig  = Ndf  * (site + m_Nvol*ex);

    for (int a = 0; a < m_Nc; ++a) {
      for (int b = a + 1; b < m_Nc; ++b) {
        double re = field[myindex(2 * (m_Nc * a + b), site, ex)]
                    - field[myindex(2 * (m_Nc * b + a), site, ex)];
        double im = field[myindex(2 * (m_Nc * a + b) + 1, site, ex)]
                    + field[myindex(2 * (m_Nc * b + a) + 1, site, ex)];

        field[myindex(2 * (m_Nc * a + b), site, ex)]     = 0.5 * re;
        field[myindex(2 * (m_Nc * a + b) + 1, site, ex)] = 0.5 * im;

        field[myindex(2 * (m_Nc * b + a), site, ex)]     = -0.5 * re;
        field[myindex(2 * (m_Nc * b + a) + 1, site, ex)] = 0.5 * im;
      }
    }
    double tr = 0.0;
    for (int cc = 0; cc < m_Nc; ++cc) {
      tr += field[myindex(2 * (m_Nc * cc + cc) + 1, site, ex)];
    }
    tr = tr / m_Nc;
    for (int cc = 0; cc < m_Nc; ++cc) {
      field[myindex(2 * (m_Nc * cc + cc), site, ex)]      = 0.0;
      field[myindex(2 * (m_Nc * cc + cc) + 1, site, ex)] -= tr;
    }
  }
}


//====================================================================
void Field_G::ah_Field_G(int ex)
{
  assert(ex < m_Nex);

  //  int Ndf  = 2 * m_Nc * m_Nc;

  for (int site = 0; site < m_Nvol; ++site) {
    //    int ig  = Ndf  * (site + m_Nvol*ex);

    for (int a = 0; a < m_Nc; ++a) {
      for (int b = a; b < m_Nc; ++b) {
        double re = field[myindex(2 * (m_Nc * a + b), site, ex)]
                    - field[myindex(2 * (m_Nc * b + a), site, ex)];
        double im = field[myindex(2 * (m_Nc * a + b) + 1, site, ex)]
                    + field[myindex(2 * (m_Nc * b + a) + 1, site, ex)];

        field[myindex(2 * (m_Nc * a + b), site, ex)]     = 0.5 * re;
        field[myindex(2 * (m_Nc * a + b) + 1, site, ex)] = 0.5 * im;

        field[myindex(2 * (m_Nc * b + a), site, ex)]     = -0.5 * re;
        field[myindex(2 * (m_Nc * b + a) + 1, site, ex)] = 0.5 * im;
      }
    }
  }
}


//====================================================================
//============================================================END=====
