/*!
        @file    $Id:: field.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "field.h"
#include <fstream>

#include "bridgeIO.h"
using Bridge::vout;

using std::string;

//====================================================================
void Field::write_text(string filename)
{
  // This function works only on single node.
  assert(CommonParameters::NPE() == 1);

  std::fstream field_out;
  field_out.open(filename.c_str(), std::ios::out);
  if (!field_out.is_open()) {
    std::cout << "Failed to open the text file." << __FILE__ << "(" << __LINE__ << ")" << std::endl;
    abort();
  }

  vout.general(m_vl, "Writing Field to %s\n", filename.c_str());

  field_out << m_Nin << std::endl;
  field_out << m_Nvol << std::endl;
  field_out << m_Nex << std::endl;

  field_out.setf(std::ios_base::scientific, std::ios_base::floatfield);
  field_out.precision(14);

  int Nsize = m_Nin * m_Nvol * m_Nex;
  for (int j = 0; j < Nsize; ++j) {
    field_out << field[j] << std::endl;
  }

  field_out.close();

  vout.general(m_vl, "Writing Field finished.\n");
}


//====================================================================
void Field::read_text(string filename)
{
  // This function works only on single node.
  assert(CommonParameters::NPE() == 1);

  std::fstream field_in;
  field_in.open(filename.c_str(), std::ios::in);
  if (!field_in.is_open()) {
    std::cout << "Failed to open the text file." << __FILE__ << "(" << __LINE__ << ")" << std::endl;
    abort();
  }
  vout.general(m_vl, "Reading Field from %s\n", filename.c_str());

  int Nin, Nvol, Nex;
  field_in >> Nin;
  field_in >> Nvol;
  field_in >> Nex;

  if (m_Nin * m_Nvol * m_Nex != 0) {
    assert(Nin == m_Nin);
    assert(Nvol == m_Nvol);
    assert(Nex == m_Nex);
  } else {
    reset(Nin, Nvol, Nex);
    //    m_Nin  = Nin;
    //    m_Nvol = Nvol;
    //    m_Nex  = Nex;
  }

  int Nsize = m_Nin * m_Nvol * m_Nex;
  for (int j = 0; j < Nsize; ++j) {
    field_in >> field[j];
  }

  field_in.close();

  vout.general(m_vl, "Reading Field finished.\n");
}


//====================================================================
void Field::stat(double& Fave, double& Fmax, double& Fdev)
{
  double sum  = 0.0;
  double sum2 = 0.0;

  Fmax = 0.0;
  for (int ex = 0; ex < m_Nex; ++ex) {
    for (int site = 0; site < m_Nvol; ++site) {
      double fst = 0.0;
      for (int in = 0; in < m_Nin; ++in) {
        double fv = field[myindex(in, site, ex)];
        fst += fv * fv;
      }
      sum2 += fst;
      fst   = sqrt(fst);
      sum  += fst;
      if (fst > Fmax) Fmax = fst;
    }
  }

  sum  = Communicator::reduce_sum(sum);
  sum2 = Communicator::reduce_sum(sum2);
  Fmax = Communicator::reduce_max(Fmax);

  int NPE = CommonParameters::NPE();
  Fave = sum / ((double)m_Nvol * m_Nex * NPE);

  double fval = sum2 / ((double)m_Nvol * m_Nex * NPE);
  fval -= Fave * Fave;
  Fdev  = sqrt(fval);
}


//====================================================================
//============================================================END=====
