/*!
        @file    $Id:: field_F_SF#$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef FIELD_F_SF_INCLUDED
#define FIELD_F_SF_INCLUDED

#include "commonParameters.h"
#include "communicator.h"
//#include "field_F.h"
//#include "field_G.h"
#include "vec_SU_N.h"

//! A class generated to add a function for the SF.

/*!
  <ul>
  <li>A function to set the boundary field.
  <li>This class does not contain the filed object but manipulate it.
  <li>[3 Apr 2012 Y.Taniguchi]
  </ul>
 */
class Field_F_SF {
 private:
  int m_Nc2;  // num of the double color elements
  int m_Nvol; // lattice volume
  int m_Nd;   // num of the spinor elements
  int m_Nin;  // internal d.o.f.
  int Svol;

 public:
  Field_F_SF() :
    m_Nvol(CommonParameters::Nvol()),
    m_Nd(CommonParameters::Nd())
  {
    int Nc = CommonParameters::Nc();

    m_Nc2 = 2 * Nc;
    int Nt = CommonParameters::Nt();
    Svol = m_Nvol / Nt;
  }

/*!
  Set the boundary field to zero: \f$f(t=0,\vec{x})=0\f$
 */
  void set_boundary_zero(Field& f)
  {
    if (Communicator::ipe(3) == 0) {
      for (int site = 0; site < Svol; ++site) {
        for (int s = 0; s < m_Nd; ++s) {
          for (int cc = 0; cc < m_Nc2; ++cc) {
            f.set(cc + m_Nc2 * s, site, 0, 0.0);
          }
        }
      }
    }
  }
};
#endif
