/*!
        @file    $Id:: shiftField_lex.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef SHIFTFIELD_LEX_INCLUDED
#define SHIFTFIELD_LEX_INCLUDED

#include <iostream>

#include "communicator.h"
#include "commonParameters.h"

#include "field.h"
#include "index_lex.h"

//! Methods to shift the field in lexical site index.

/*!
   This class defines the methods which shift a given Field
   instance in specified direction.
   The foreward shift means, e.g. in x-direction,
   v(site) = w(site-\hat{mu}), where v is the shifted field
   (output, first argument) and w the original field (input,
   second argument).
   Names of private functions might be still confusing.
                                   [25 Dec 2011 H.Matsufuru]
 */
class ShiftField_lex {
 private:
  int       Nx, Ny, Nz, Nt;
  Index_lex idx;

 public:
  ShiftField_lex() :
    Nx(CommonParameters::Nx()),
    Ny(CommonParameters::Ny()),
    Nz(CommonParameters::Nz()),
    Nt(CommonParameters::Nt())
  {
  }

  void forward(Field&, const Field&, const int mu);
  void backward(Field&, const Field&, const int mu);

  void forward(Field&, const Field&, const int bc, const int mu);
  void backward(Field&, const Field&, const int bc, const int mu);

 private:
  void up_x(Field *, const Field *, const int bc);
  void up_y(Field *, const Field *, const int bc);
  void up_z(Field *, const Field *, const int bc);
  void up_t(Field *, const Field *, const int bc);
  void dn_x(Field *, const Field *, const int bc);
  void dn_y(Field *, const Field *, const int bc);
  void dn_z(Field *, const Field *, const int bc);
  void dn_t(Field *, const Field *, const int bc);
};
#endif
