/*!
        @file    $Id:: sortField.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef SORTFIELD_INCLUDED
#define SORTFIELD_INCLUDED

#include <valarray>
#include "field.h"

#ifdef USE_FACTORY
#include "factory.h"
#endif

//! Base class for sorting pair instances (value,field).

/*!
   This class is used to sort the paired instances of
   (value,field) to some specific order.
   Mainly assumed to be used in eigenvalue solver.
                                  [28 Dec 2011 H.Matsufuru]
 */

class SortField
{
 public:
  virtual ~SortField() {}
  virtual void sort(int, std::valarray<double>&) = 0;
  virtual void sort(int, std::valarray<double>&, std::valarray<Field>&) = 0;
  virtual int converged(double v, double v_thrs) = 0;

#ifdef USE_FACTORY
 public:
  typedef SortField *(*ProductCreator)();
  typedef FactoryTemplate<SortField, ProductCreator>   Factory;

  static SortField *New(const IdentifierType& subtype)
  {
    ProductCreator p = Factory::Find(subtype);

    return p ? (*p)() : 0;
  }
#endif
};
#endif
