/*!
        @file    $Id:: sortField_AbsHigh.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#include "sortField_AbsHigh.h"

#ifdef USE_FACTORY
namespace {
  SortField *create_object()
  {
    return new SortField_AbsHigh();
  }


  bool init = SortField::Factory::Register("High", create_object);
}
#endif


void SortField_AbsHigh::sort(int Nk, std::valarray<double>& D, std::valarray<Field>& vk)
{
  Field wtmp(vk[0]);

  for (int init = 0; init < Nk - 1; ++init) {
    int    kmax = init;
    double dmax = fabs(D[init]);

    for (int k = init + 1; k < Nk; ++k) {
      if (fabs(D[k]) > dmax) {
        kmax = k;
        dmax = fabs(D[k]);
      }
    }

    if (kmax != init) {
      dmax     = D[kmax];
      D[kmax]  = D[init];
      D[init]  = dmax;
      wtmp     = vk[init];
      vk[init] = vk[kmax];
      vk[kmax] = wtmp;
    }
  }
}


/* ====================================================== */
void SortField_AbsHigh::sort(int Nk, std::valarray<double>& D)
{
  for (int init = 0; init < Nk - 1; ++init) {
    int    kmax = init;
    double dmax = fabs(D[init]);

    for (int k = init + 1; k < Nk; ++k) {
      if (fabs(D[k]) > dmax) {
        kmax = k;
        dmax = fabs(D[k]);
      }
    }

    if (kmax != init) {
      dmax    = D[kmax];
      D[kmax] = D[init];
      D[init] = dmax;
    }
  }
}
