/*!
        @file    $Id:: sortField_AbsLow.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#include "sortField_AbsLow.h"

#include <valarray>
using std::valarray;

#ifdef USE_FACTORY
namespace {
  SortField *create_object()
  {
    return new SortField_AbsLow();
  }


  bool init = SortField::Factory::Register("Low", create_object);
}
#endif

void SortField_AbsLow::sort(int Nk, valarray<double>& D, valarray<Field>& vk)
{
  Field wtmp(vk[0]);

  for (int init = 0; init < Nk - 1; ++init) {
    int    kmin = init;
    double dmin = fabs(D[init]);

    for (int k = init + 1; k < Nk; ++k) {
      if (fabs(D[k]) < dmin) {
        kmin = k;
        dmin = fabs(D[k]);
      }
    }

    if (kmin != init) {
      dmin     = D[kmin];
      D[kmin]  = D[init];
      D[init]  = dmin;
      wtmp     = vk[init];
      vk[init] = vk[kmin];
      vk[kmin] = wtmp;
    }
  }
}


/* ====================================================== */
void SortField_AbsLow::sort(int Nk, valarray<double>& D)
{
  for (int init = 0; init < Nk - 1; ++init) {
    int    kmin = init;
    double dmin = fabs(D[init]);

    for (int k = init + 1; k < Nk; ++k) {
      if (fabs(D[k]) < dmin) {
        kmin = k;
        dmin = fabs(D[k]);
      }
    }

    if (kmin != init) {
      dmin    = D[kmin];
      D[kmin] = D[init];
      D[init] = dmin;
    }
  }
}
