/*!
        @file    $Id:: sortField_AbsLow.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef SORTFIELD_ABSLOW_INCLUDED
#define SORTFIELD_ABSLOW_INCLUDED

#include <valarray>

#include "sortField.h"


//! Sorting (value,field) in ascending order of abs(value).

/*!
   This class is used to sort the paired instances of
   (value,field) in ascending order of absolute values.
   Mainly assumed to be used in eigenvalue solver.
                                  [28 Dec 2011 H.Matsufuru]
 */

class SortField_AbsLow : public SortField
{
 public:
  void sort(int, std::valarray<double>&);
  void sort(int, std::valarray<double>&, std::valarray<Field>&);

  int converged(double v, double v_thrs)
  {
    if (fabs(v) > fabs(v_thrs)) return 1;

    return 0;
  }
};
#endif
