/*!
        @file    $Id:: fopr_Chebyshev.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef FOPR_CHEBYSHEV_INCLUDED
#define FOPR_CHEBYSHEV_INCLUDED

#include "fopr.h"
#include "field_F.h"
#include "index_lex.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Chebyshev polynomial of fermion operator.

/*!
    This class implements Chebyshev polynomial of a given
    fermion operator by making use of Clenshow's reccurence
    formula.
    The present version is just a rough implementation which
    assumes to be used accelerate eigenvalue solver.
                                    [24 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.            [14 Nov 2012 Y.Namekawa]
 */


//- parameters class
class Parameters_Fopr_Chebyshev : virtual public Parameters
{
 public:
  Parameters_Fopr_Chebyshev();
};
//- end

class Fopr_Chebyshev : public Fopr
{
 private:
  int    m_Npcb;
  double m_Fcb1, m_Fcb2;
  Fopr   *m_fopr;

 public:

  Fopr_Chebyshev(Fopr *fopr)
    : Fopr(), m_fopr(fopr) {}

  void set_parameters(const Parameters& params);
  void set_parameters(int Np, double v_thrs, double v_max);

  void set_config(Field *U)
  {
    m_fopr->set_config(U);
  }

  const Field mult(const Field& f);

  void mult(Field& v, const Field& f)
  {
    v = mult(f);
  }

  const Field mult_dag(const Field& f)
  {
    return mult(f);
  }

  void mult_dag(Field& v, const Field& f)
  {
    v = mult_dag(f);
  }

  //!  evaluate for a number
  double mult(double);

  int field_nvol() { return m_fopr->field_nvol(); }
  int field_nin() { return m_fopr->field_nin(); }
  int field_nex() { return m_fopr->field_nex(); }
};
#endif
