/*!
        @file    $Id:: fopr_Rational.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef FOPR_RATIONAL_INCLUDED
#define FOPR_RATIONAL_INCLUDED

#include "fopr.h"
#include "field_G.h"
#include "shiftsolver_CG.h"
#include "math_Rational.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Fopr_Rational : virtual public Parameters
{
 public:
  Parameters_Fopr_Rational();
};
//- end

//! Fermion operator for rational approximation.

/*!
    This class generates fermion operator with rational approximation
    for a given fermion operator (given to the constructer).
    Shift-solver is used which is at present set to the CG solver
    explicitly.
                                     [05 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.             [14 Nov 2012 Y.Namekawa]
 */

class Fopr_Rational : public Fopr
{
 private:
  int    m_Np;              // number of poles in rational approx.
  int    m_n_exp, m_d_exp;  // numerator and denominator of the exponent
  double m_x_min, m_x_max;  // valid range of approximate sign function
  int    m_Niter;           // max iteration of shiftsolver
  double m_Stop_cond;       // stopping condition of shift solver

  Fopr           *m_fopr;
  Shiftsolver_CG *m_solver;

  double                m_a0;
  std::valarray<double> m_cl;
  std::valarray<double> m_bl;
  std::valarray<Field>  m_xq;

 public:

  Fopr_Rational(Fopr *fopr)
    : Fopr(), m_fopr(fopr) {}

  ~Fopr_Rational()
  {
    delete m_solver;
  }

  void set_parameters(const Parameters& params);
  void set_parameters(int Np, int n_exp, int d_exp, double x_min, double x_max,
                      int Niter, double Stop_cond);

  void set_config(Field *U)
  {
    m_fopr->set_config(U);
  }

  const Field mult(const Field& f);

  void mult(Field& v, const Field& f)
  {
    v = mult(f);
  }

  const Field mult_dag(const Field& f)
  {
    return mult(f);
  }

  void mult_dag(Field& v, const Field& f)
  {
    v = mult_dag(f);
  }

  double func(double x);

  int field_nvol() { return m_fopr->field_nvol(); }
  int field_nin() { return m_fopr->field_nin(); }
  int field_nex() { return m_fopr->field_nex(); }

 private:
  void init_parameters();
};
#endif
