/*!
        @file    $Id:: fopr_Wilson.cpp #$

        @brief

        @author  Hideo Matsufuru <hideo.matsufuru@kek.jp> (matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-03-21 15:28:34 #$

        @version $LastChangedRevision: 930 $
*/

#include "fopr_Wilson.h"
#include "fopr_Wilson_impl.h"

#ifdef USE_PARAMETERS_FACTORY
#include "parameters_factory.h"
#endif

using std::valarray;

//- parameter entries
namespace {
  void append_entry(Parameters& param)
  {
    param.Register_string("gamma_matrix_type", "NULL");
    param.Register_double("hopping_parameter", 0.0);
    param.Register_int_vector("boundary_condition", std::valarray<int>());

    param.Register_string("verbose_level", "NULL");
  }


#ifdef USE_PARAMETERS_FACTORY
  bool init_param = ParametersFactory::Register("Fopr.Wilson", append_entry);
#endif
}
//- end

//- parameters class
Parameters_Fopr_Wilson::Parameters_Fopr_Wilson() { append_entry(*this); }
//- end

//====================================================================
void Fopr_Wilson::set_parameters(const Parameters& params)
{
  const string str_vlevel = params.get_string("verbose_level");

  m_vl = vout.set_verbose_level(str_vlevel);

  //- fetch and check input parameters
  double        kappa;
  valarray<int> bc;

  int err = 0;
  err += params.fetch_double("hopping_parameter", kappa);
  err += params.fetch_int_vector("boundary_condition", bc);

  if (err) {
    vout.crucial(m_vl, "Fopr_Wilson: fetch error, input parameter not found.\n");
    abort();
  }


  set_parameters(kappa, bc);
}


//====================================================================
void Fopr_Wilson::set_parameters(const double kappa, const std::valarray<int> bc)
{ m_impl->set_parameters(kappa, bc); }


//====================================================================
Fopr_Wilson::Fopr_Wilson() : Fopr(), m_impl(new Fopr_Wilson_impl)
{ m_impl->init("Dirac"); }

//====================================================================
Fopr_Wilson::Fopr_Wilson(std::string repr) : Fopr(), m_impl(new Fopr_Wilson_impl)
{ m_impl->init(repr); }

//====================================================================
Fopr_Wilson::~Fopr_Wilson() { delete m_impl; }


//====================================================================
void Fopr_Wilson::set_config(Field *U)
{ m_impl->set_config(U); }

//====================================================================
void Fopr_Wilson::set_mode(std::string mode)
{ m_impl->set_mode(mode); }

//====================================================================
std::string Fopr_Wilson::get_mode() const
{ return m_impl->get_mode(); }

//====================================================================
void Fopr_Wilson::mult(Field& v, const Field& f)
{ m_impl->mult(v, f); }

//====================================================================
void Fopr_Wilson::mult_dag(Field& v, const Field& f)
{ m_impl->mult_dag(v, f); }

//====================================================================
void Fopr_Wilson::mult_gm5(Field& w, const Field& v)
{ m_impl->mult_gm5(w, v); }


//====================================================================
void Fopr_Wilson::D(Field& w, const Field& v)
{ m_impl->D(w, v); }

//====================================================================
void Fopr_Wilson::Ddag(Field& w, const Field& v)
{ m_impl->Ddag(w, v); }

//====================================================================
void Fopr_Wilson::DdagD(Field& w, const Field& v)
{ m_impl->DdagD(w, v); }

//====================================================================
void Fopr_Wilson::H(Field& w, const Field& v)
{ m_impl->H(w, v); }


//====================================================================
const Field_F Fopr_Wilson::mult_gm5p(int mu, const Field_F& w)
{ return m_impl->mult_gm5p(mu, w); }

//====================================================================
//! adding the hopping to nearest neighbor site in mu-th direction.
void Fopr_Wilson::mult_up(int mu, Field& w, const Field& v)
{ m_impl->mult_up(mu, w, v); }

//====================================================================
void Fopr_Wilson::mult_dn(int mu, Field& w, const Field& v)
{ m_impl->mult_dn(mu, w, v); }


//====================================================================
void Fopr_Wilson::fprop_normalize(Field& v)
{ m_impl->fprop_normalize(v); }

//====================================================================
void Fopr_Wilson::fopr_normalize(Field& v)
{ m_impl->fopr_normalize(v); }

//====================================================================
//============================================================END=====
