/*!
        @file    $Id:: force.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_INCLUDED
#define FORCE_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field.h"

//! Base class of fermion force calculation.

/*!
    This class defines the interface of fermion force calculation.
    force_udiv() and force_udiv1() are used to recursively
    determine the smeared fermion force.
                                       [28 Dec 2011 H.Matsufuru]
    set_mode() is added. This is for the cases when the force
    calculation is nonhermitian.       [18 Jan 2012 H.Matsufuru]
*/

class Force
{
 public:

  Force()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Force() {}

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void set_config(Field *) = 0;

  //! in Force, setting the mode is optional when H is nonhermitian.
  virtual void set_mode(std::string mode)
  {
    // do nothing if not defined in a subclass.
  }

  virtual Field force_core(const Field&) = 0;
  virtual Field force_udiv(const Field&) = 0;

  virtual Field force_core1(const Field&, const Field&) { return Field(); }
  virtual Field force_udiv1(const Field&, const Field&) { return Field(); }

 protected:
  Bridge::VerboseLevel m_vl;
};
#endif
