/*!
        @file    $Id:: forceSmear.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCESMEAR_INCLUDED
#define FORCESMEAR_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field_G.h"

#include "projection.h"

#include "bridgeIO.h"

#ifdef USE_FACTORY
#include "factory.h"
#endif


//! Base class for force calculation of smeared operators.

/*!
                                     [28 Dec 2011 H.Matsufuru]
 */

class ForceSmear
{
 public:

  ForceSmear()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~ForceSmear() {}

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual Field force_udiv(const Field_G&, const Field_G&) = 0;

 protected:
  Bridge::VerboseLevel m_vl;


#ifdef USE_FACTORY
 public:
  typedef ForceSmear *(*ProductCreator)(Projection *);
  typedef FactoryTemplate<ForceSmear, ProductCreator>   Factory;

  static ForceSmear *New(const IdentifierType& subtype, Projection *proj)
  {
    ProductCreator p = Factory::Find(subtype);

    return p ? (*p)(proj) : 0;
  }
#endif
};
#endif
