/*!
        @file    $Id:: forceSmear_APE.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCESMEAR_APE_INCLUDED
#define FORCESMEAR_APE_INCLUDED

#include "forceSmear.h"
#include "smear_APE.h"

#include "bridge_complex.h"
#include "shiftField_lex.h"

#include "projection.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Recursive calculation for APE smeared fermion force.

/*!
                                [08 Apr 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.        [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
//! Parameters class for ForceSmear_APE class.
class Parameters_ForceSmear_APE : virtual public Parameters
{
 public:
  Parameters_ForceSmear_APE();
};
//- end

class ForceSmear_APE : public ForceSmear
{
 private:
  int m_Ndim, m_Nvol;
  std::valarray<double>  m_rho;
  Projection             *m_proj;
  ShiftField_lex         m_shift;
  std::valarray<Field_G> m_U;
  std::valarray<Field_G> m_iTheta;

 public:

  ForceSmear_APE(Projection *proj)
    : ForceSmear(), m_proj(proj)
  {
    init();
  }

  //  ~ForceSmear_APE(){
  //  };

  // Setting parameters with Parameters object.
  void set_parameters(const Parameters& params);

  // Setting parameters with Parameters for Smear_APE class.
  // void set_parameters (const Parameters_Smear_APE& params);

  // Setting parameters with uniform smearing parameter.
  void set_parameters(const double rho1);

  // Setting parameters with anisotropic smearing parameter.
  void set_parameters(const std::valarray<double>& rho);

  // Force computation.
  Field force_udiv(const Field_G& Sigma, const Field_G& U);

 private:

  void init();

  double rho(int mu, int nu)
  {
    return m_rho[mu + nu * m_Ndim];
  }

  void force_each(Field_G&, const Field_G&, const Field_G&,
                  const Field_G&, const Field_G&, int mu, int nu);

  void staple(Field_G&, const Field_G&, const Field_G&,
              int mu, int nu);
};
#endif
