/*!
        @file    $Id:: forceSmear_APE_SF.h #$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCESMEAR_APE_ALT_INCLUDED
#define FORCESMEAR_APE_ALT_INCLUDED

#include "forceSmear.h"
#include "smear_APE_SF.h"
#include "field_G_SF.h"

#include "shiftField_lex.h"
#include "bridge_complex.h"

#include "projection.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Recursive calculation for APE smeared fermion force.

/*!
                                [08 Apr 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.        [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_ForceSmear_APE_SF : virtual public Parameters
{
 public:
  Parameters_ForceSmear_APE_SF();
};
//- end

class ForceSmear_APE_SF : public ForceSmear
{
 private:
  int m_Ndim, m_Nvol;
  std::valarray<double>  m_rho;
  Projection             *m_proj;
  ShiftField_lex         m_shift;
  std::valarray<Field_G> m_U;
  std::valarray<Field_G> m_iTheta;

  //! SF boundary condition at t=0
  double m_phi[3];
  //! SF boundary condition at t=Nt
  double m_phipr[3];

  Field_G_SF set_wk;

 public:

  ForceSmear_APE_SF(Projection *proj)
    : ForceSmear(), m_proj(proj)
  {
    init();
  }

  //  ~ForceSmear_APE_SF(){
  //  };

  void set_parameters(const Parameters& params);

//  void set_parameters (const Parameters_Smear_APE_SF& params);

  void set_parameters(const double rho1, double *phi, double *phipr);
  void set_parameters(const std::valarray<double>& rho, double *phi, double *phipr);

  Field force_udiv(const Field_G& Sigma, const Field_G& U);

 private:

  void init();

  double rho(int mu, int nu)
  {
    return m_rho[mu + nu * m_Ndim];
  }

  void force_each(Field_G&, const Field_G&, const Field_G&,
                  const Field_G&, const Field_G&, int mu, int nu);

  void staple(Field_G&, const Field_G&, const Field_G&,
              int mu, int nu);
};
#endif
