/*!
        @file    $Id:: force_F_CloverTerm.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_F_CLOVERTERM_INCLUDED
#define FORCE_F_CLOVERTERM_INCLUDED

#include "force.h"
#include "fopr_CloverTerm.h"

#include "staples.h"
#include "shiftField_lex.h"
#include "tensorProd.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Force calculation for clover term of clover fermion.

/*!
    This class calculate contribution clover term to the clover
    fermion action.
                                [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.        [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
//! Parameters class for Force_F_CloverTerm.
class Parameters_Force_F_CloverTerm : virtual public Parameters
{
 public:
  Parameters_Force_F_CloverTerm();
};
//- end

class Force_F_CloverTerm : public Force
{
 private:
  double             m_kappa;    //!< hopping parameter
  double             m_cSW;      //!< clover coefficient
  std::valarray<int> m_boundary; //!< boundary conditions

  std::string m_repr;            //!< gamma matrix representation

  Field_G         *m_U;          //!< pointer to gauge field
  int             m_Ndim;        //!< spacetime dimension
  Field_G         *m_Cud;        //!< for force calculation
  Fopr_CloverTerm *m_fopr_csw;   //!< fermion operator

 public:
  //! Constructor
  Force_F_CloverTerm()
    : Force()
  {
    init("Dirac");    //!< default gamma matrix representation
  }

  Force_F_CloverTerm(std::string repr)
    : Force()
  {
    init(repr);    //!< default gamma matrix representation
  }

  //! Deconstructor
  ~Force_F_CloverTerm()
  {
    tidyup();
  }

  //! Setting parameters of clover fermion force.
  void set_parameters(const Parameters& params);

  //! Setting parameters with clover fermion parameters.
  // void set_parameters (const Parameters_Fopr_CloverTerm& params);

  //! Setting parameters with clover fermion parameters.
  void set_parameters(double kappa, double cSW, const std::valarray<int> bc);

  //! Setting gauge configuration
  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
    m_fopr_csw->set_config(m_U);
    //    m_forcew->set_config(U);
    set_component();
  }

  //! Force determination for clover fermion.
  Field force_core(const Field& eta);

  //! Force determination for clover fermion.
  Field force_core1(const Field& zeta, const Field& eta);

  //! For recursive calculation of smeared force.
  Field force_udiv(const Field& eta);

  //! For recursive calculation of smeared force.
  Field force_udiv1(const Field& zeta, const Field& eta);

 private:

  void init(std::string);
  void tidyup();

  //! Core implemetation of clover force calculation.
  Field force_udiv1_impl(const Field_F& zeta, const Field_F& eta);

  //! Set building components for force calculation.
  void set_component();

  int index_dir(int mu, int nu)
  {
    return mu + m_Ndim * nu;
  }
};
#endif
