/*!
        @file    $Id:: force_F_Clover_SF.h #$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_F_CLOVER_SF_INCLUDED
#define FORCE_F_CLOVER_SF_INCLUDED

#include "fopr_Clover_SF.h"
#include "force_F_Wilson_SF.h"
#include "field_G_SF.h"
#include "staples_SF.h"

#include "tensorProd.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Force calculation for clover quark action with SF BC.

/*!
    At present, only the Dirac representation for gamma-matrix
    is available.
                                [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.        [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Force_F_Clover_SF : virtual public Parameters
{
 public:
  Parameters_Force_F_Clover_SF();
};
//- end

class Force_F_Clover_SF : public Force
{
 private:
  double             m_kappa;      //!< hopping parameter
  double             m_cSW;        //!< clover coefficient
  std::valarray<int> m_boundary;   //!< boundary conditions
  Field_G            *m_U;         //!< pointer to gauge field

  int     m_Ndim;
  Field_G *m_Cud;                  //!< for force calculation

  Fopr_Clover_SF    *m_fopr_c;
  Force_F_Wilson_SF *m_force_w;
  Force_F_Clover_SF *m_imp;

  //! SF boundary condition at t=0
  double m_phi[3];
  //! SF boundary condition at t=Nt
  double m_phipr[3];

  //! In order to set the boundary field.
  Field_F_SF set_zero;
  Field_G_SF set_wk;

 public:

  Force_F_Clover_SF()
  {
    m_fopr_c  = new Fopr_Clover_SF;
    m_force_w = new Force_F_Wilson_SF;

    int Nvol = CommonParameters::Nvol();
    m_Ndim = CommonParameters::Ndim();

    m_boundary.resize(m_Ndim);
    m_Cud = new Field_G(Nvol, m_Ndim * m_Ndim);
  }

  ~Force_F_Clover_SF()
  {
    delete m_Cud;
    delete m_force_w;
    delete m_fopr_c;
  }

  void set_parameters(const Parameters& params);

  // void set_parameters (const Parameters_Fopr_Clover_SF& params);

  //! Setting parameters of clover fermion.
  void set_parameters(double kappa, double cSW, const std::valarray<int> bc,
                      double *phi, double *phipr);

  //! Setting gauge configuration
  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
    m_fopr_c->set_config(m_U);
    m_force_w->set_config(U);
    set_component();
  }

  //! Force determination for clover fermion.
  Field force_core(const Field& eta);

  //! Force determination for clover fermion.
  Field force_core1(const Field& zeta, const Field& eta);

  //! For recursive calculation of smeared force.
  Field force_udiv(const Field& eta);

  //! For recursive calculation of smeared force.
  Field force_udiv1(const Field& zeta, const Field& eta);

 private:

  //! Core implemetation of clover force calculation.
  Field force_udiv1_impl(const Field_F& zeta, const Field_F& eta);

  //! Set building components for force calculation.
  void set_component();

  int index_dir(int mu, int nu)
  {
    return mu + m_Ndim * nu;
  }
};
#endif
