/*!
        @file    $Id:: force_F_Rational.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_F_RATIONAL_INCLUDED
#define FORCE_F_RATIONAL_INCLUDED

#include "force.h"
#include "fopr_Rational.h"
#include "math_Rational.h"
#include "field_F.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Force calculation for smeared fermion operators.

/*!
    This class determine the force of rational approximation
    for a given fermion operator.
                                    [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.            [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Force_F_Rational : virtual public Parameters
{
 public:
  Parameters_Force_F_Rational();
};
//- end

class Force_F_Rational : public Force
{
 private:
  int    m_Np;             // number of poles in rational approx.
  int    m_n_exp, m_d_exp; // numerator and denominator of the exponent
  double m_x_min, m_x_max; // valid range of approximate sign function
  int    m_Niter;          // max iteration of shiftsolver
  double m_Stop_cond;      // stopping condition of shift solver

  Field_G *m_U;

  Fopr  *m_fopr;
  Force *m_force;

  // rational approx. coefficients
  double                m_a0;
  std::valarray<double> m_bl;
  std::valarray<double> m_cl;

 public:

  Force_F_Rational(Fopr *fopr, Force *force)
    : Force(), m_fopr(fopr), m_force(force) {}

  ~Force_F_Rational() {}

  void set_parameters(const Parameters& params);

  //  void set_parameters (const Parameters_Fopr_Rational& params);
  void set_parameters(int Np, int n_exp, int d_exp, double x_min, double x_max,
                      int Niter, double Stop_cond);

  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
    m_fopr->set_config(U);
    m_force->set_config(U);
  }

  Field force_core(const Field&);
  Field force_udiv(const Field&);

  // Field force_core1(const Field_F&, const Field_F&);

 private:
  void init_parameters();
};
#endif
