/*!
        @file    $Id:: force_F_Smeared.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "force_F_Smeared.h"

//====================================================================
void Force_F_Smeared::set_parameters(const Parameters& params)
{
  const string str_vlevel = params.get_string("verbose_level");

  m_vl = vout.set_verbose_level(str_vlevel);
}


//====================================================================
Field Force_F_Smeared::force_core(const Field& eta)
{
  int Nc   = CommonParameters::Nc();
  int Nvol = CommonParameters::Nvol();
  int Ndim = CommonParameters::Ndim();

  Field_G  force(Nvol, Ndim), force1(Nvol, Ndim);
  Mat_SU_N ut(Nc);

  force1 = force_udiv(eta);

  for (int mu = 0; mu < Ndim; ++mu) {
    force.mult_Field_Gnn(mu, *m_U, mu, force1, mu);
    force.at_Field_G(mu);
  }

  force *= -2.0;

  return (Field)force;
}


//====================================================================
Field Force_F_Smeared::force_core1(const Field& zeta, const Field& eta)
{
  int Nc   = CommonParameters::Nc();
  int Nvol = CommonParameters::Nvol();
  int Ndim = CommonParameters::Ndim();

  Field_G  force(Nvol, Ndim), force1(Nvol, Ndim);
  Mat_SU_N ut(Nc);

  force1 = force_udiv1(zeta, eta);

  for (int mu = 0; mu < Ndim; ++mu) {
    force.mult_Field_Gnn(mu, *m_U, mu, force1, mu);
    force.at_Field_G(mu);
  }
  force *= -2.0;

  return (Field)force;
}


//====================================================================
Field Force_F_Smeared::force_udiv1(const Field& zeta, const Field& eta)
{
  int Nvol = CommonParameters::Nvol();
  int Ndim = CommonParameters::Ndim();

  Field_G force(Nvol, Ndim);

  int Nsmear = m_dr_smear->get_Nsmear();

  if (Nsmear == 0) {
    force = m_force->force_udiv1(zeta, eta);
  } else {
    Field_G force1(Nvol, Ndim);
    Field_G Usmear(Nvol, Ndim);
    Field   *Uptr;

    Uptr   = m_dr_smear->getptr_smearedConfig(Nsmear);
    Usmear = (Field_G) * Uptr;

    m_force->set_config((Field *)&Usmear);
    force1 = m_force->force_udiv1(zeta, eta);

    for (int ismear = Nsmear - 1; ismear > 0; --ismear) {
      Uptr   = m_dr_smear->getptr_smearedConfig(ismear);
      Usmear = (Field_G) * Uptr;

      force  = m_force_smear->force_udiv(force1, Usmear);
      force1 = force;
    }

    Usmear = *m_U;
    force  = m_force_smear->force_udiv(force1, Usmear);
  }

  return (Field)force;
}


//====================================================================
Field Force_F_Smeared::force_udiv(const Field& eta)
{
  int Nvol = CommonParameters::Nvol();
  int Ndim = CommonParameters::Ndim();

  Field_G force(Nvol, Ndim);

  int Nsmear = m_dr_smear->get_Nsmear();

  if (Nsmear == 0) {
    force = m_force->force_udiv(eta);
  } else {
    Field_G force1(Nvol, Ndim);
    Field_G Usmear(Nvol, Ndim);
    Field   *Uptr;

    Uptr   = m_dr_smear->getptr_smearedConfig(Nsmear);
    Usmear = (Field_G) * Uptr;

    m_force->set_config((Field *)&Usmear);
    force1 = m_force->force_udiv(eta);

    for (int ismear = Nsmear - 1; ismear > 0; --ismear) {
      Uptr   = m_dr_smear->getptr_smearedConfig(ismear);
      Usmear = (Field_G) * Uptr;

      force  = m_force_smear->force_udiv(force1, Usmear);
      force1 = force;
    }

    Usmear = *m_U;
    force  = m_force_smear->force_udiv(force1, Usmear);
  }

  return (Field)force;
}


//====================================================================
//============================================================END=====
