/*!
        @file    $Id:: force_F_Smeared.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_F_SMEARED_INCLUDED
#define FORCE_F_SMEARED_INCLUDED

#include "force.h"
#include "forceSmear.h"
#include "fopr.h"
#include "director_Smear.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Force calculation for smeared fermion operators.

/*!
    This class determines the force of smeared fermion operator
    using smearing director (Director_Smear instance) and base
    fermion force instance.
                                      [28 Dec 2011 H.Matsufuru]
    Modified: set_mode() is added to incorporate non-hermitian H
                                      [21 Jan 2012 H.Matsufuru]
*/

class Force_F_Smeared : public Force
{
 private:
  Field_G        *m_U;
  Force          *m_force;
  ForceSmear     *m_force_smear;
  Director_Smear *m_dr_smear;

 public:

  Force_F_Smeared(
    Force *force, ForceSmear *force_smear, Director_Smear *dr_smear)
    : Force(), m_force(force), m_force_smear(force_smear), m_dr_smear(dr_smear) {}

  void set_parameters(const Parameters&);

  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
    m_dr_smear->set_config(U);
    m_force->set_config(U);
  }

  void set_mode(std::string mode)
  {
    m_force->set_mode(mode);
  }

  Field force_core(const Field& eta);
  Field force_udiv(const Field& eta);

  Field force_core1(const Field& zeta, const Field& eta);
  Field force_udiv1(const Field& zeta, const Field& eta);
};
#endif
