/*!
        @file    $Id:: force_F_Wilson_Nf2.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_F_WILSON_NF2_INCLUDED
#define FORCE_F_WILSON_NF2_INCLUDED

#include "force.h"
#include "fopr_Wilson.h"

#include "tensorProd.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Force for the standard Wilson fermion operator

/*!
    This class calculate the force of the standard Wilson fermion.
    The gamma matrix representation is given as control string
    "Dirac"(default) or "Chiral" at the construction, which is
    used to construct the Fopr_Wilson instance.
                                     [23 Dec 2011 H.Matusfuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.             [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Force_F_Wilson_Nf2 : virtual public Parameters
{
 public:
  Parameters_Force_F_Wilson_Nf2();
};
//- end

class Force_F_Wilson_Nf2 : public Force
{
 private:
  Field_G *m_U;

  double             m_kappa;
  std::valarray<int> m_boundary;
  Fopr_Wilson        *m_fopr_w;
  Field_F            m_psf;
  std::string        m_repr;

 public:
  Force_F_Wilson_Nf2()
    : Force()
  {
    m_repr   = "Dirac";
    m_fopr_w = new Fopr_Wilson(m_repr);
    m_boundary.resize(CommonParameters::Ndim());
  }

  Force_F_Wilson_Nf2(std::string repr)
    : Force()
  {
    m_repr   = repr;
    m_fopr_w = new Fopr_Wilson(m_repr);
    m_boundary.resize(CommonParameters::Ndim());
  }

  ~Force_F_Wilson_Nf2()
  {
    delete m_fopr_w;
  }

  void set_parameters(const Parameters& params);

  // void set_parameters (const Parameters_Fopr_Wilson& params);
  void set_parameters(const double kappa, const std::valarray<int> bc);

  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
    m_fopr_w->set_config(U);
  }

  Field force_core(const Field& eta);
  Field force_core1(const Field& zeta, const Field& eta);

  Field force_udiv(const Field& eta);
  Field force_udiv1(const Field& zeta, const Field& eta);
  Field force_udiv1(const Field_F& zeta, const Field_F& eta);
};
#endif
