/*!
        @file    $Id:: force_F_Wilson_eo.h #$

        @brief

        @author  <UEDA, Satoru> sueda@post.kek.jp(sueda)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef FORCE_F_WILSON_EO_INCLUDED
#define FORCE_F_WILSON_EO_INCLUDED

#include "force.h"

#include "fopr_Wilson_eo.h"
#include "index_eo.h"

#include "gammaMatrix.h"

#include "tensorProd.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Force for the Wilson fermion operator with even-odd precondition

/*!
    This class calculate the force of the standard Wilson fermion.
    The gamma matrix representation is given as control string
    "Dirac"(default) or "Chiral" at the construction, which is
    used to construct the Fopr_Wilson instance.
                                     [19 June 2012 S.UEDA]
    (Coding history will be recovered from trac.)
    YAML is implemented.             [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Force_F_Wilson_eo : virtual public Parameters
{
 public:
  Parameters_Force_F_Wilson_eo();
};
//- end

class Force_F_Wilson_eo : public Force
{
 private:
  Field_G *m_U;
  Field_G *m_Ueo;

  double             m_kappa;
  std::valarray<int> m_boundary;
  Fopr_Wilson_eo     *m_fopr_w;
  Field_F            m_psf;
  std::string        m_repr;

  Index_eo m_index;

 public:

  Force_F_Wilson_eo()
    : Force()
  {
    m_repr   = "Dirac";
    m_fopr_w = new Fopr_Wilson_eo(m_repr);
    m_boundary.resize(CommonParameters::Ndim());
  }

  Force_F_Wilson_eo(std::string repr)
    : Force()
  {
    m_repr   = repr;
    m_fopr_w = new Fopr_Wilson_eo(m_repr);
    m_boundary.resize(CommonParameters::Ndim());
  }

  ~Force_F_Wilson_eo()
  {
    delete m_fopr_w;
  }

  void set_parameters(const Parameters& params);
  void set_parameters(double kappa, const std::valarray<int> bc);

  void set_config(Field *U)
  {
    m_U = (Field_G *)U;
    m_fopr_w->set_config(U);
  }

  //! return the force field form the fermion field on the even site.
  //! force_core = force_core1(eta, H eta) + force_core1(H eta, eta)
  //!            = U * force_udiv
  Field force_core(const Field& eta);

  //! return the force field, differentiated by the gauge field U form the fermion field on the even site.
  //! force_udiv = force_udiv1(eta, H eta) + force_udiv1(H eta, eta)
  Field force_udiv(const Field& eta);

  //! eta and zeta are the fermion fields on the even-odd site
  //! eta_o = M_oe eta_e
  //! zeta_e = g_5 (1- M_eo M_oe) eta_e
  //! zeta_o = M_oe zeta_o
  Field force_core1(const Field& zeta, const Field& eta);

  Field force_udiv1(const Field& zeta, const Field& eta);
  Field force_udiv1(const Field_F& zeta, const Field_F& eta);
};
#endif
