/*!
        @file    $Id:: hmc_General.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef HMC_GENERAL_INCLUDED
#define HMC_GENERAL_INCLUDED

#include "action.h"
#include "director.h"
#include "integrator.h"
#include "randomNumbers.h"
#include "staples.h"

#include "bridgeIO.h"
using Bridge::vout;

using std::valarray;

//! General HMC update class.

/*
    This class defines Hybrid Monte Carlo update algorithm
    with a given molecular dynamics integrator.
    To be improved:
    - at present setting conjugate momenta explicitly assumes
      SU(3) gauge group. This should be generalized, and for
      SU(3) case assert is necessary.
                                   [25 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_HMC_General : virtual public Parameters
{
 public:
  Parameters_HMC_General();
};
//- end

class HMC_General
{
 private:
  int                  m_Mtpl_test;   //!< Metropolis test: Mtpl_test=0: no test, !=0: test
  valarray<Action *>   m_action;      //!< actions
  valarray<Director *> m_director;    //!< directors
  Integrator           *m_integrator; //!< MD integrator
  RandomNumbers        *m_rand;       //!< random number generator
  Staples              *m_staple;
  Bridge::VerboseLevel m_vl;

 public:
  //! constructor with actions, directors, and random number generator
  HMC_General(std::valarray<Action *> action,
              std::valarray<Director *> director,
              Integrator *integrator,
              RandomNumbers *rand)
    : m_vl(CommonParameters::Vlevel())
  {
    m_action.resize(action.size());
    for (int i = 0; i < action.size(); ++i) {
      m_action[i] = action[i];
    }
    m_director.resize(director.size());
    for (int i = 0; i < director.size(); ++i) {
      m_director[i] = director[i];
    }
    m_integrator = integrator;
    m_rand       = rand;
    m_staple     = new Staples;
    m_Mtpl_test  = 0;
  }

  //! constructor when no director is necessary
  HMC_General(std::valarray<Action *> action,
              Integrator *integrator,
              RandomNumbers *rand)
    : m_vl(CommonParameters::Vlevel())
  {
    m_action.resize(action.size());
    for (int i = 0; i < action.size(); ++i) {
      m_action[i] = action[i];
    }
    m_integrator = integrator;
    m_rand       = rand;
    m_staple     = new Staples;
    m_Mtpl_test  = 0;
  }

  //! destructor
  ~HMC_General()
  {
    delete m_staple;
  }

  void set_parameters(const Parameters& params);
  void set_parameters(int Mtpl_test);

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  double update(Field_G&);

  double langevin(Field_G& iP, Field_G& U);
  double langevin_P(Field_G& iP);

  double calc_Hamiltonian(Field_G& iP, Field_G& U);
  double calcH_P(Field_G& iP);
};
#endif
