/*!
        @file    $Id:: integrator.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef INTEGRATOR_INCLUDED
#define INTEGRATOR_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field_G.h"

#include "bridgeIO.h"

//! Base class of Integrator class family.

/*!
   This class defines the interface of Integrator-type classes.
                                        [25 Dec 2011 H.Matsufuru]
 */

class Integrator
{
 public:

  Integrator()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Integrator() {}

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void evolve(Field_G& iP, Field_G& U) = 0;

 protected:
  Bridge::VerboseLevel m_vl;
};
#endif
