/*!
        @file    $Id:: integrator_Leapfrog.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef INTEGRATOR_LEAPFROG_INCLUDED
#define INTEGRATOR_LEAPFROG_INCLUDED

#include "action.h"
#include "director.h"
#include "integrator.h"
#include "randomNumbers.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Standard leapfrog integrator to compose MD integrator.

/*!
                                     [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.             [03 Mar 2013 Y.Namekawa]
 */

//- parameters class
class Parameters_Integrator_Leapfrog : virtual public Parameters
{
 public:
  Parameters_Integrator_Leapfrog();
};
//- end

class Integrator_Leapfrog : public Integrator
{
 private:
  double                  m_Estep;  // step size of each molecular dynamical evolution
  int                     m_Nstep;  // number of steps
  int                     m_level;  // level number
  Integrator              *m_integ_next;
  std::valarray<Action *> m_action; // actions

 public:
  //! constructor with actions and next level integrator.
  Integrator_Leapfrog(std::valarray<Action *> action,
                      Integrator *integ_next)
  {
    m_action.resize(action.size());
    for (int i = 0; i < action.size(); ++i) {
      m_action[i] = action[i];
    }
    m_integ_next = integ_next;
    m_Estep      = 0.0;
    m_Nstep      = 0;
  }

  //! destructor
  ~Integrator_Leapfrog()
  {
    // std::cout << "byebye from integrator_leapfrog.\n";
  }

  void set_parameters(const Parameters& params);
  void set_parameters(int level, double Estep, int Nstep);

  void evolve(Field_G& iP, Field_G& U);
};
#endif
