/*!
        @file    $Id:: integrator_UpdateU.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef INTEGRATOR_UPDATEU_INCLUDED
#define INTEGRATOR_UPDATEU_INCLUDED

#include "action.h"
#include "director.h"
#include "integrator.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Integrator of link variable for a given conjugate momenta.

/*!
    In the present implementation, exponential of matrix is determined
    by Taylor series, and whose degree (m_Nprec) is explicitly
    specified in the class definition.
                                          [25 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.                  [03 Mar 2013 Y.Namekawa]
 */

//- parameters class
class Parameters_Integrator_UpdateU : virtual public Parameters
{
 public:
  Parameters_Integrator_UpdateU();
};
//- end

class Integrator_UpdateU : public Integrator
{
 private:
  double m_Estep;                       // step size
  int    m_Nprec;                       // precision of exponential series
  std::valarray<Action *>   m_action;   // actions
  std::valarray<Director *> m_director; // directors

 public:
  //! constructor with actions, directors, and random number generator
  Integrator_UpdateU(std::valarray<Action *> action,
                     std::valarray<Director *> director)
  {
    m_action.resize(action.size());
    for (int i = 0; i < action.size(); ++i) {
      m_action[i] = action[i];
    }
    m_director.resize(director.size());
    for (int i = 0; i < director.size(); ++i) {
      m_director[i] = director[i];
    }
    m_Estep = 0.0;
    m_Nprec = 0;
  }

  //! constructor when no director is necessary
  Integrator_UpdateU(std::valarray<Action *> action)
  {
    m_action.resize(action.size());
    for (int i = 0; i < action.size(); ++i) {
      m_action[i] = action[i];
    }
    m_Estep = 0.0;
    m_Nprec = 0;
  }

  //! destructor
  ~Integrator_UpdateU() {}

  void set_parameters(const Parameters& params);
  void set_parameters(double Estep, int Nprec);

  void evolve(Field_G& iP, Field_G& U);
};
#endif
