/*!
        @file    $Id:: bridgeIO.cpp #$

        @brief

        @author  Satoru Ueda <sueda@post.kek.jp> (sueda)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
 */

#include "bridgeIO.h"
#include "commonParameters.h"

//====================================================================
// verbose output for c style
// default verbose level, node 0

namespace Bridge {
  //====================================================================
  void
  BridgeIO::crucial(const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(CommonParameters::Vlevel(), Bridge::CRUCIAL, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::general(const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(CommonParameters::Vlevel(), Bridge::GENERAL, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::detailed(const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(CommonParameters::Vlevel(), Bridge::DETAILED, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::paranoiac(const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(CommonParameters::Vlevel(), Bridge::PARANOIAC, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  // input verbose level, node 0
  void
  BridgeIO::crucial(VerboseLevel vl, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::CRUCIAL, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::general(VerboseLevel vl, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::GENERAL, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::detailed(VerboseLevel vl, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::DETAILED, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::paranoiac(VerboseLevel vl, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::PARANOIAC, 0, format, arg);
    va_end(arg);
  }


  //====================================================================
  // input verbose level, input node
  void
  BridgeIO::crucial(VerboseLevel vl, int node, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::CRUCIAL, node, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::general(VerboseLevel vl, int node, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::GENERAL, node, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::detailed(VerboseLevel vl, int node, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::DETAILED, node, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::paranoiac(VerboseLevel vl, int node, const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    print(vl, Bridge::PARANOIAC, node, format, arg);
    va_end(arg);
  }


  //====================================================================
  void
  BridgeIO::ildg(const char *format, ...)
  {
    va_list arg;

    va_start(arg, format);
    vsprintf(buff_, format, arg);
    va_end(arg);
    if ((Communicator::nodeid() == 0)) {
      if (ildg_os_) {
        *ildg_os_ << "@ILDG:" << buff_;
      } else {
        *os_ << "@ILDG:" << buff_;
      }
    }
  }


  //====================================================================
  VerboseLevel
  BridgeIO::set_verbose_level(const std::string& str)
  {
    if (str == "Crucial") return Bridge::CRUCIAL;

    if (str == "General") return Bridge::GENERAL;

    if (str == "Detailed") return Bridge::DETAILED;

    if (str == "Paranoiac") return Bridge::PARANOIAC;

    if (str == "NULL") return CommonParameters::Vlevel();

    return Bridge::GENERAL;
  }


  BridgeIO vout;
}
