/*!
        @file    $Id:: bridgeIO.h #$

        @brief

        @author  Satoru Ueda <sueda@post.kek.jp> (sueda)
                 $LastChangedBy: namekawa $

        @date    $LastChangedDate:: 2013-06-19 01:18:08 #$

        @version $LastChangedRevision: 897 $
 */

#ifndef BRIDGEIO_INCLUDED
#define BRIDGEIO_INCLUDED

#include <iostream>
#include <fstream>
#include <cstdarg>

//#include "commonParameters.h"
#include "communicator.h"

namespace Bridge {
  enum VerboseLevel
  {
    CRUCIAL,
    GENERAL,
    DETAILED,
    PARANOIAC
  };

  class BridgeIO {
   public:
    // Constructor
    BridgeIO() : os_(0), ildg_os_(0), is_open_(false) {}
    ~BridgeIO() {}

    // Constructor from a stream
    void init(std::ostream& os)
    {
      os_      = &os;
      is_open_ = true;
    }

    void ildg_init(std::ostream& os)
    {
      ildg_os_ = &os;
    }

    // verbose output for c style
    // default verbose level, node 0
    void crucial(const char *format, ...);
    void general(const char *format, ...);
    void detailed(const char *format, ...);
    void paranoiac(const char *format, ...);

    // input verbose level, node 0
    void crucial(VerboseLevel vl, const char *format, ...);
    void general(VerboseLevel vl, const char *format, ...);
    void detailed(VerboseLevel vl, const char *format, ...);
    void paranoiac(VerboseLevel vl, const char *format, ...);

    // input verbose level, input node
    void crucial(VerboseLevel vl, int node, const char *format, ...);
    void general(VerboseLevel vl, int node, const char *format, ...);
    void detailed(VerboseLevel vl, int node, const char *format, ...);
    void paranoiac(VerboseLevel vl, int node, const char *format, ...);

    void ildg(const char *format, ...);

    std::ostream& getStream() { return *os_; }
    std::ostream& getILDGStream() { return *ildg_os_; }

    // Is the stream open?
    bool isOpen() { return is_open_; }

    static VerboseLevel set_verbose_level(const std::string& str);

   private:
    // main method for verbose output for c style
    inline void print(VerboseLevel level, VerboseLevel write_level,
                      int node, const char *format, va_list& arg)
    {
      if ((write_level <= level) && (Communicator::nodeid() == node)) {
        //*os_ << Communicator::nodeid() << " " << node << " ";
        vsprintf(buff_, format, arg);
        *os_ << buff_;
      }
    }

    // Hide copy constructor and =
    BridgeIO(const BridgeIO&) {}
    void operator=(const BridgeIO&) {}

   private:
    std::ostream *os_;
    std::ostream *ildg_os_;
    char         buff_[1024];
    bool         is_open_;
  };

  extern BridgeIO vout;
}
#endif //BRIDGE_IO_INCLUDED
