/*!
        @file    $Id: dataIO.h 943 2013-07-22 07:55:30Z sueda $
        @brief
        @author
                 $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-22 16:55:30 +0900 (月, 22  7月 2013) $
        @version $LastChangedRevision: 943 $
*/

#ifndef DATAIO_INCLUDED
#define DATAIO_INCLUDED

//#define DEBUG_IO

#ifdef DEBUG_IO
#define ENTER    printf(">>> %s\n", __PRETTY_FUNCTION__)
#else
#define ENTER
#endif

#include "bridge_complex.h"

#include "commonParameters.h"
#include "bridgeIO.h"
using Bridge::vout;

#include <string>
using std::string;

#include <valarray>
using std::valarray;

//! DataIO class for file I/O of general collection of data.

/**
   DataIO class provides abstract base class for file I/O of
   general collection of data that do not have space-time index.

   interfaces defined for reading and writing array of double and complex
   of size n, and valarray of double and complex.

 */

class DataIO
{
 public:
  DataIO() : m_vl(CommonParameters::Vlevel()) { ENTER; }
  virtual ~DataIO() { ENTER; }

  virtual void read_file(double *v, const size_t n, const string&) = 0;
  virtual void write_file(const double *v, const size_t n, const string&, const bool append = true) = 0;

  virtual void read_file(dcomplex *v, const size_t n, const string&) = 0;
  virtual void write_file(const dcomplex *v, const size_t n, const string&, const bool append = true) = 0;

  virtual void read_file(valarray<double>&, const string&) = 0;
  virtual void write_file(const valarray<double>&, const string&, const bool append = true) = 0;

  virtual void read_file(valarray<dcomplex>&, const string&) = 0;
  virtual void write_file(const valarray<dcomplex>&, const string&, const bool append = true) = 0;

 protected:
  Bridge::VerboseLevel m_vl;
};
#endif /* DATAIO_INCLUDED */
