/*!
        @file    $Id: dataIO_Text.h 943 2013-07-22 07:55:30Z sueda $
        @brief
        @author
                 $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-22 16:55:30 +0900 (月, 22  7月 2013) $
        @version $LastChangedRevision: 943 $
*/

#ifndef DATAIO_TEXT_INCLUDED
#define DATAIO_TEXT_INCLUDED

#include "dataIO.h"
#include <string>
using std::string;

#include <fstream>
using std::fstream;

enum
{
  default_format_precision = 14,
};

//! DataIO_Text class for general file I/O in plain Text format.

/**
   DataIO_Text class provides file I/O in plain Text format.
   output format of numerical precision can be specified through
   set_parameter method. default is given as enum.

   Data are read from/written to file through the primary node
   (rank 0 usually).

   The read/write methods in various data formats are all derived from
   template functions whose implementation given in dataIO_Text_impl.h
   included at the bottom.
 */

class DataIO_Text : public DataIO
{
 public:
  DataIO_Text() : m_format_precision(default_format_precision) { ENTER; }
  ~DataIO_Text() { ENTER; }

  virtual void read_file(double *v, const size_t n, const string& f)
  { return read_file_base(v, n, f); }
  virtual void write_file(const double *v, const size_t n, const string& f, const bool append = true)
  { return write_file_base(v, n, f, append); }

  virtual void read_file(dcomplex *v, const size_t n, const string& f)
  { return read_file_base(v, n, f); }
  virtual void write_file(const dcomplex *v, const size_t n, const string& f, const bool append = true)
  { return write_file_base(v, n, f, append); }

  virtual void read_file(valarray<double>& v, const string& f)
  { return read_file_base(&v[0], v.size(), f); }
  virtual void write_file(const valarray<double>& v, const string& f, const bool append = true)
//    { return write_file_base(&v[0], v.size(), f, append); }
  {    // workaround for standard-compliant definition of operator[]
    valarray<double>& p = const_cast<valarray<double>&>(v);
    return write_file_base(&p[0], v.size(), f, append);
  }

  virtual void read_file(valarray<dcomplex>& v, const string& f)
  { return read_file_base(&v[0], v.size(), f); }
  virtual void write_file(const valarray<dcomplex>& v, const string& f, const bool append = true)
//    { return write_file_base(&v[0], v.size(), f, append); }
  {
    valarray<dcomplex>& p = const_cast<valarray<dcomplex>&>(v);
    return write_file_base(&p[0], v.size(), f, append);
  }

  void set_parameter(const int precision) { m_format_precision = precision; }

 private:
  int m_format_precision;

  template<typename T>
  void read_file_base(T *v, const size_t n, const string&);

  template<typename T>
  void write_file_base(const T *v, const size_t n, const string&, const bool append = true);

  template<typename T>
  inline void fetch_data(T& v, fstream& fs);

  template<typename T>
  inline void store_data(const T& v, fstream& fs);
};

#include "dataIO_Text_impl.h"
#endif /* DATAIO_TEXT_INCLUDED */
