/*!
        @file    $Id: dataIO_Text_impl.h 930 2013-07-12 07:56:41Z sueda $
        @brief
        @author
                 $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-12 16:56:41 +0900 (金, 12  7月 2013) $
        @version $LastChangedRevision: 930 $
*/

#ifndef DATAIO_TEXT_IMPL_INCLUDED
#define DATAIO_TEXT_IMPL_INCLUDED

template<typename T>
void DataIO_Text::read_file_base(T *v, const size_t n, const string& filename)
{
  ENTER;

  if (Communicator::is_primary()) {
    vout.detailed(m_vl, "reading data to %s.\n", filename.c_str());

    std::fstream fs(filename.c_str(), std::ios::in);
    if (!fs.is_open()) {
      vout.crucial(m_vl, "read file failed.\n");
      abort();
    }

    for (size_t i = 0; i < n; ++i) {
      fetch_data<T>(v[i], fs);
    }

    fs.close();
  }

  vout.general(m_vl, "read successful.\n");
}


template<typename T>
void DataIO_Text::write_file_base(const T *v, const size_t n, const string& filename, const bool append)
{
  ENTER;

  if (Communicator::is_primary()) {
    vout.detailed(m_vl, "writing data to %s.\n", filename.c_str());

    std::fstream fs(filename.c_str(), std::ios::out | (append ? std::ios::app : std::ios::trunc));
    if (!fs.is_open()) {
      vout.crucial(m_vl, "write file failed.\n");
      abort();
    }

    fs.setf(std::ios_base::scientific, std::ios_base::floatfield);
    fs.precision(m_format_precision);

    for (size_t i = 0; i < n; ++i) {
      store_data<T>(v[i], fs);
    }

    fs.close();
  }

  vout.general(m_vl, "write successful.\n");
}


template<>
inline void
DataIO_Text::store_data<double> (const double& v, fstream& fs)
{
  fs << v << std::endl;
}


template<>
inline void
DataIO_Text::store_data<dcomplex> (const dcomplex& v, fstream& fs)
{
  fs << real(v) << "\t" << imag(v) << std::endl;
}


template<>
inline void
DataIO_Text::fetch_data<double> (double& v, fstream& fs)
{
  double val;

  fs >> val;
  v = val;
}


template<>
inline void
DataIO_Text::fetch_data<dcomplex> (dcomplex& v, fstream& fs)
{
  double valr, vali;

  fs >> valr >> vali;
  v = cmplx(valr, vali);
}
#endif /* DATAIO_TEXT_IMPL_INCLUDED */
