/*!
        @file    $Id: fieldIO_Binary.h 943 2013-07-22 07:55:30Z sueda $
        @brief
        @author  $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-22 16:55:30 +0900 (月, 22  7月 2013) $
        @version $LastChangedRevision: 943 $
*/


#ifndef FIELDIO_BINARY_INCLUDED
#define FIELDIO_BINARY_INCLUDED

#include <string>
using std::string;

#include "fieldIO.h"
#include "index_lex.h"
#include "field.h"

//! FieldIO_Binary class for file I/O of Field data in binary format.

/*!
   The file format treated in this class is the same as ILDG
   file format, while not packed to LIME file.
   The endian is big as the definition of ILDG file.
                                        [28 Dec 2011 H.Matsufuru]

   FieldIO_Binary class provides file I/O of Field data in binary format.
   The inferface is defined in the FieldIO base class, and this class
   defines concrete realisation.

   File I/O is performed on the primary node (rank 0 usually), and
   the field data is gathered from/scattered to parallel nodes.
   Extra memory of global field size is temporarily allocated internally
   as workspace, which may restrict operativity for huge lattice.
 */

class FieldIO_Binary : public FieldIO
{
 public:
  FieldIO_Binary(const IO_Format::Format *format) : FieldIO(format)
  {
  }

  void read_file(Field *v, string filename);
  void write_file(Field *v, string filename);
};
#endif
