/*!
        @file    $Id: fieldIO_Binary_Parallel.h #$
        @brief
        @author  $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-01-22 13:51:53 #$
        @version $LastChangedRevision: 943 $
*/

#ifndef FIELDIO_BINARY_PARALLEL_INCLUDED
#define FIELDIO_BINARY_PARALLEL_INCLUDED

#include <string>
using std::string;

#ifdef USE_MPI
#include <mpi.h>
#include "communicator_mpi.h"
#endif

#include "fieldIO.h"

#include "bridgeIO.h"
using Bridge::vout;

//! FieldIO_Binary_Parallel class for file I/O of Field data in binary format using MPI parallel I/O.

/*!
    The file format treated in this class is the same as ILDG
    file format, while not packed to LIME file.
    The endian is big as the definition of ILDG file.
                                        [28 Dec 2011 H.Matsufuru]

    FieldIO_Binary_Parallel provides file I/O of Field data in binary format.
    File I/O is performed in parallel relying on MPI I/O.
    The interface is defined in the FieldIO base class, and this class
    defines concrete realisation.

    Parallel I/O is enabled when USE_MPI option is turned on; otherwise
    this class is an alias of FieldIO_Binary that provides serial I/O.
 */

#ifdef USE_MPI
class FieldIO_Binary_Parallel : public FieldIO
{
 public:
  FieldIO_Binary_Parallel(const IO_Format::Format *format) : FieldIO(format), m_is_initialized(false) {}

  void read_file(Field *v, string filename);
  void write_file(Field *v, string filename);

 private:

  bool m_is_initialized;  //!< check if initialisation is done.

  int m_nvol;

  MPI_Datatype m_type_vector; //!< internal block
  MPI_Datatype m_type_tiled;  //!< subarray of blocks

  int initialize();           //!< initialise MPI datatypes for mapping data location to glboal layout.
};

#else

// for Single version, just an alias of FieldIO_Binary.

class FieldIO_Binary_Parallel : public FieldIO_Binary
{
 public:
  FieldIO_Binary_Parallel(const IO_Format::Format *format) : FieldIO_Binary(format) {}
};
#endif
#endif
