/*!
        @file    $Id: fieldIO_Fortran.h 943 2013-07-22 07:55:30Z sueda $
        @brief
        @author  $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-22 16:55:30 +0900 (月, 22  7月 2013) $
        @version $LastChangedRevision: 943 $
*/


#ifndef FIELDIO_FORTRAN_INCLUDED
#define FIELDIO_FORTRAN_INCLUDED

#include <string>
using std::string;

#include "fieldIO.h"
#include "index_lex.h"
#include "field.h"

//! FieldIO_Fortran class for file I/O of Field data in Fortran binary format.

/*!
   This class reads configuration from binary data file
   generated by Fortran code.
   Before opening file, endian of the file must be specified
   using set_fileEndian() function.
   Only input from file is available.
                                        [28 Dec 2011 H.Matsufuru]

   FieldIO_Fortran class provides file I/O of Field data in Fortran binary
   format. Fortran binary data record has heading and trailing bytes
   that represents length of the record.
   The size of heading and trailer is 4 (32bit) in this implementation.

   File I/O is performed on the primary node (rank 0 usually), and
   the field data is gathered from/scattered to parallel nodes.
 */

/*!
   In this class, we assumed the data alignment as followes,\n
   \verbatim double U[NDIMENSION][NT][NZ][NY][NX][NCOLOR][NCOLOR][2] \endverbatim
   (i.e. the rightmost index runs fastest)

   [11 June 2012 S.UEDA]

   Data layout is specified by format specified at constructor.
   The above corresponds to JLQCD layout.
 */


class FieldIO_Fortran : public FieldIO
{
 public:
  FieldIO_Fortran(const IO_Format::Format *format) : FieldIO(format)
  {
  }

  void read_file(Field *v, std::string filename);
  void write_file(Field *v, std::string filename);
};
#endif
