/*!
        @file    $Id: fieldIO_Text.cpp 930 2013-07-12 07:56:41Z sueda $
        @brief
        @author  $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-12 16:56:41 +0900 (金, 12  7月 2013) $
        @version $LastChangedRevision: 930 $
*/


#include "fieldIO_Text.h"

#include <iostream>
#include <fstream>

#include "commonParameters.h"
#include "communicator.h"
#include "bridgeIO.h"
using Bridge::vout;

#include "field.h"


//====================================================================
void FieldIO_Text::read_file(Field *v, string filename)
{
  int nin_field = v->nin();
  int nex_field = v->nex();

  int nin_file = m_format->nin();
  int nex_file = m_format->nex();

  if ((nin_file == 0) || (nex_file == 0)) {
    nin_file = nin_field;
    nex_file = nex_field;
  }

  int Lvol = CommonParameters::Lvol();

  vout.detailed(m_vl, "%s: file format: nin=%d, nex=%d, Lvol=%d\n", __func__, nin_file, nex_file, Lvol);
  vout.detailed(m_vl, "%s: field format: nin=%d, nex=%d, Lvol=%d\n", __func__, nin_field, nex_field, v->nvol());

  // temporary field holding the whole space-time data.
  Field vtmp;

  if (Communicator::is_primary()) {
    vout.detailed(m_vl, "reading field data from %s\n", filename.c_str());

    vtmp.reset(nin_field, Lvol, nex_field);

    std::fstream config(filename.c_str(), std::ios::in);
    if (!config.is_open()) {
      vout.crucial(m_vl, "read file failed\n");
      abort();
    }

    int    s, t;
    double val;
    for (int j = 0; j < nex_file; ++j) {
      for (int isite = 0; isite < Lvol; ++isite) {
        for (int i = 0; i < nin_file; ++i) {
          config >> val;

          m_format->file_to_field(s, t, i, j);
          vtmp.set(s, isite, t, val);
        }
      }
    }

    config.close();
  }

  FieldIO::deliver(v, &vtmp);

  vout.detailed(m_vl, "read successful\n");
}


//====================================================================
void FieldIO_Text::write_file(Field *v, std::string filename)
{
  if (v == 0) {
    vout.crucial(m_vl, "%s: field empty.\n", __func__);
    return;
  }

  int nin_field = v->nin();
  int nex_field = v->nex();

  int nin_file = m_format->nin();
  int nex_file = m_format->nex();

  if ((nin_file == 0) || (nex_file == 0)) {
    nin_file = nin_field;
    nex_file = nex_field;
  }

  int Lvol = CommonParameters::Lvol();

  vout.detailed(m_vl, "%s: file format: nin=%d, nex=%d, Lvol=%d\n", __func__, nin_file, nex_file, Lvol);
  vout.detailed(m_vl, "%s: field format: nin=%d, nex=%d, Lvol=%d\n", __func__, nin_field, nex_field, v->nvol());

  // temporary field holding the whole space-time data.
  Field vtmp;
  if (Communicator::is_primary()) {
    vtmp.reset(nin_field, Lvol, nex_field);
  }

  FieldIO::gather(&vtmp, v);

  if (Communicator::is_primary()) {
    vout.detailed(m_vl, "writing field data to %s\n", filename.c_str());

    std::fstream config(filename.c_str(), std::ios::out);
    if (!config.is_open()) {
      vout.crucial(m_vl, "write file failed\n");
      abort();
    }

    config.setf(std::ios_base::scientific, std::ios_base::floatfield);
    config.precision(14);

    int    s, t;
    double val;
    for (int j = 0; j < nex_file; ++j) {
      for (int isite = 0; isite < Lvol; ++isite) {
        for (int i = 0; i < nin_file; ++i) {
          m_format->file_to_field(s, t, i, j);

          val = vtmp.cmp(s, isite, t);
          config << val << std::endl;
        }
      }
    }

    config.close();
  }

  vout.detailed(m_vl, "write successful\n");
}


//====================================================================
//============================================================END=====
