/*!
        @file    $Id: fieldIO_Text.h 943 2013-07-22 07:55:30Z sueda $
        @brief
        @author  $LastChangedBy: sueda $
        @date    $LastChangedDate: 2013-07-22 16:55:30 +0900 (月, 22  7月 2013) $
        @version $LastChangedRevision: 943 $
*/


#ifndef FIELDIO_TEXT_INCLUDED
#define FIELDIO_TEXT_INCLUDED

#include <string>
using std::string;

#include "fieldIO.h"
#include "index_lex.h"
#include "field.h"

//! FieldIO_Text class for file I/O of Field data in plain text format.

/*!
   The format of the gauge configuration is assumed to
   the same as ILDG standard index order.
                                    [28 Dec 2011 H.Matsufuru]

   FieldIO_Text class provides file I/O of Field data in plain text format.

   File I/O is performed on the primary node (rank 0 usually), and
   the field data is gathered from/scattered to parallel nodes.
*/

class FieldIO_Text : public FieldIO
{
 public:
  FieldIO_Text(const IO_Format::Format *format) : FieldIO(format)
  {
//    d_prefix  = "conf_";
//    d_postfix = ".txt";
  }

  void read_file(Field *v, string filename);
  void write_file(Field *v, string filename);
};
#endif
